(function($) {
  "use strict";

  /*
   *@Param Gmap
   */
  if ($(".Awe_param.gmap").length) {
    setTimeout(function () {
      var latlong = $(".Awe_map_latlong").val();
      latlong = latlong.split(',');

      var center = new google.maps.LatLng(latlong[0], latlong[1]);
      var zoom = $(".Awe_map_zoom").val() == '' ? 12 : parseInt($(".Awe_map_zoom").val());

      $('input.Awe_search_map').geocomplete({
        map: ".Awe_show_map",
        mapOptions: {
          zoom: zoom,
          center: center,
        },
        markerOptions: {
          draggable: true
        }
      }).bind("geocode:result", function (event, result) {

        var lat = Object.keys(result.geometry.location)[0];
        lat = result.geometry.location.lat();

        var lng = Object.keys(result.geometry.location)[1];
        lng = result.geometry.location.lng();
        console.log(lat, lng);

        $(".Awe_map_latlong").val(lat + "," + lng).trigger('change');
        // console.log(result);
      }).bind('geocode:zoom', function (event, result) {
        // console.log(result);
        $(".Awe_map_zoom").val(result).trigger('change');
      }).bind('geocode:dragged', function (event, result) {
        // console.log(result);
      });

    }, 1000);
  }

  $(document).on('change', '.Awe_map_latlong, .Awe_map_zoom', function() {
    var $param = $(this).closest('.Awe_param');
    var value = $param.find('.vc_input').serialize();
    // console.log(value);
    $param.find(".awe_param_gmap_field").val(encodeURIComponent(value));
  });
})(jQuery);