var Awe_dialog = {};
(function ($) {
    'use strict';
    $(document).on('click', '.Awe_dialog .media-modal-close', function (e) {
        Awe_dialog.close();
        e.preventDefault();
    });
    /*
     *@Event Tab select 
     */
    $(document).on('click', '.Awe_dialog .media-router a', function (e) {
        if (!$(this).hasClass('active')) {
            //Changed nav
            $(".awe-modal .media-router a").removeClass("active");
            $(this).addClass('active');
            var id = $(this).attr('href').replace('#', '');
            //Changed content
            $(".awe-modal-content.active").removeClass('active');
            $(".awe-modal #awe_" + id).addClass('active');
            if (Awe_dialog.contentIsEmpty(id)) {
                window[Awe_dialog.addon].print(id);
            }
        }
        e.preventDefault();
    });

    //On Click item
    $(document).on('click', '.Awe_dialog .Awe_dialog_list a', function (e) {

        var $this = $(this);
        var id = $this.attr('data-id');
        var Addon = window[Awe_dialog.addon];
        
        if (Awe_dialog.multiSelect) {

            if (!$this.hasClass('selected')) {

                $this.addClass('selected');
                Addon.values[id] = $this.attr('data-data');
            } else {

                $this.removeClass('selected');
                delete Addon.values[id];
                //Remove tag in selected items
                if ($this.closest('#awe_itemselected').length) {
                    $this.parent().remove();
                }

            }

            var counter = Object.keys(Addon.values).length;
            Awe_dialog.setCounter(counter);
            if (counter > 0) {
                $(".Awe_icon .Awe_insert").removeAttr('disabled');
                Awe_dialog.find('.edit-selection').show();
                Awe_dialog.find('.clear-selection').show();
            } else {
                $(".Awe_icon .Awe_insert").attr('disabled', 'disabled');
                Awe_dialog.find('.edit-selection').hide();
                Awe_dialog.find('.clear-selection').hide();
            }

            /*
             *@Update list preview 
             */

            if (typeof Addon.printReview == 'function') {
                Addon.printReview();
            }

        } else {

            Awe_icon.values = {};
            Awe_icon.values[id] = $this.attr('title');
            Awe_dialog.onInserted(Addon.values);
            Awe_dialog.close();
        }

        e.preventDefault();
    });
    /*
     *@On insert 
     */
    $(document).on('click', ".Awe_dialog .Awe_insert", function (e) {
        //call back onInsert
        var Addon = window[Awe_dialog.addon];
        if (typeof Addon.onInsert == 'function') {
            Addon.onInsert(e);
        }
        if (Object.keys(Addon.values).length) {
            Awe_dialog.onInserted(Addon.values);
            Awe_dialog.close();
        }
        e.preventDefault();
    });
    /*
     *@On clear all 
     */
    $(document).on('click', ".Awe_dialog .clear-selection", function (e) {
        //call back onClear
        var Addon = window[Awe_dialog.addon];
        if (typeof Addon.onClear == 'function') {
            Addon.onClear(e);
        }

        Awe_dialog.valueSelected = {};
        Awe_dialog.find('.Awe_insert').attr('disabled', 'disabled');

        /*
         *@Update list preview 
         */
        if (typeof Addon.printReview == 'function') {
            Addon.printReview();
        }

        e.preventDefault();
    });
    /*
     *@On edit selection 
     */
    $(document).on('click', ".Awe_dialog .edit-selection", function (e) {
        var $this = $(this);
        if (!$this.hasClass('back')) {

            $this.addClass('back').html('<i class="fa fa-angle-double-left"></i> Back to library');
            Awe_dialog.find('.clear-selection').hide();
            Awe_dialog.find('.media-router .media-menu-item').hide();
            if (Awe_dialog.find('.media-router .item_selected').length) {
                Awe_dialog.find('.media-router .item_selected').show();
            } else {
                Awe_dialog.find('.media-router').append('<a href="#itemselected" class="media-menu-item item_selected active">Item selected</a>');
            }

            Awe_dialog.find('.media-frame-content .awe-modal-content.active').addClass('bookmark').removeClass('active'); //Bookmark

            if (Awe_dialog.find('.media-frame-content #awe_itemselected').length) {
                Awe_dialog.find('.media-frame-content #awe_itemselected').addClass('active');
            } else {
                Awe_dialog.find('.media-frame-content').append('<div id="awe_itemselected" class="awe-modal-content active"></div>');
            }

            window[Awe_dialog.addon]['printSelected']();
        } else {
            $this.removeClass('back').text('Edit Selection');
            Awe_dialog.find('.clear-selection').show();
            Awe_dialog.find('.media-router .media-menu-item').show();
            Awe_dialog.find('.media-menu-item.item_selected').hide();
            Awe_dialog.find('#awe_itemselected').removeClass('active');
            Awe_dialog.find(".awe-modal-content.bookmark").addClass('active').removeClass('bookmark'); //Remove bookmark

        }

        e.preventDefault();
    });

    Awe_dialog = {
        addon: '',
        multiSelect: false,
        find: function (selector) {
            return $("#" + this.addon + " " + selector);
        },
        isOpen: function () {
            return this.self.length;
        },
        close: function () {
            $("#" + this.addon).parent().hide();
        },
        setCounter: function (count) {
            this.find(".Awe_counter span").text(count);
        },
        setContent: function (id_content, html) {
            this.find("#awe_" + id_content).html(html);
        },
        contentChanged: function (id_content) {
            //abstract method
        },
        onInserted: function (value) {
            //abstract method
        },
        contentIsEmpty: function (key) {
            if ($("#" + this.addon + " #awe_" + key).is(":empty")) {
                return true;
            }
            return false;
        },
        showWait: function () {
            this.find('.Awe_spiner').show();
        },
        hideWait: function () {
            this.find('.Awe_spiner').hide();
        },
        open: function (options) {
            var params = {
                addon: '',
                title: "Media panel name",
                buttonInsert: 'Insert item',
                multiSelect: false,
                valueSelected: {},
                tabs: {
                    tab1: "Tab item 1",
                    tab2: "Tab item 2"
                }
            };
            $.extend(params, options);
            if (params.addon == '') {
                alert('Awe dialog not allow a addon param is null');
                return false;
            }

            this.multiSelect = params.multiSelect;
            this.addon = params.addon;
            //Set values selected to Addon
            window[this.addon].values = params.valueSelected;
            //Set seft to object element
            this.self = jQuery("#" + params.addon);
            if (this.isOpen()) {

                /*
                 *@Show the existed dialog 
                 */
                this.self.parent().show();
                /*
                 *@Active the first tab if Tab in selected item tab 
                 */
                if (this.find('.edit-selection.back').length) {
                    this.find('.edit-selection.back').removeClass('back').text('Edit Selection');
                    this.find('.clear-selection').show();
                    this.find('.media-router .media-menu-item').show();
                    this.find('.media-menu-item.item_selected').hide();
                    this.find('#awe_itemselected').removeClass('active');
                    this.find(".awe-modal-content.bookmark").addClass('active').removeClass('bookmark'); //Remove bookmark
                }

                /*
                 * @Update counter
                 */
                var Addon = window[this.addon];
                var counter = Object.keys(Addon.values).length;
                this.setCounter(counter);
                /*
                 * 
                 * @Update selected items in list
                 */
                if (counter) {
                    this.find('.Awe_dialog_list li a').removeClass('selected');
                    $.each(this.find('.Awe_dialog_list li a'), function (index, item) {
                        var id = $(this).attr('data-id');
                        if (Addon.values[id.toString()]) {
                            $(this).addClass('selected');
                        }
                    });
                }

            } else {
                var tabs = '';
                var content = '';
                var i = 0;
                $.each(params.tabs, function (key, value) {
                    i++;
                    var active = "";
                    if (i === 1) {
                        active = "active";
                    }
                    tabs += '<a href="#' + key + '" class="media-menu-item ' + active + '">' + value + '</a>';
                    content += '<div id="awe_' + key + '" class="awe-modal-content ' + active + '"></div>';
                });
                var footer = '<div class="media-frame-toolbar">\n\
                    <div class="media-toolbar">\n\
                        <div class="media-toolbar-secondary">\n\
                        <div class="media-selection">\n\
                        <div class="selection-info">\n\
                                <span class="Awe_counter count"><span>0</span> selected</span>\n\
                                        <a class="edit-selection" href="#">Edit Selection</a>\n\
                                        <a class="clear-selection" href="#">Clear</a>\n\
                        </div>\n\
                        <div class="selection-view">\n\
                                <ul tabindex="-1" class="attachments"></ul>\n\
                        </div></div></div>\n\
                          <div class="media-toolbar-primary">\n\
                              <a href="#" class="Awe_insert button media-button button-primary button-large media-button-insert" disabled="disabled">' + params.buttonInsert + '</a>\n\
                        </div>\n\
                    </div>\n\
                </div>';
                var html = '<div tabindex="0" class="supports-drag-drop" style="position: relative;">\n\
	<div id="' + params.addon + '" class="Awe_dialog ' + params.addon + ' media-modal wp-core-ui awe-modal">\n\
		<a class="media-modal-close" href="#">\n\
			<span class="media-modal-icon"><span class="screen-reader-text">Close media panel</span></span>\n\
		</a>\n\
		<div class="media-modal-content">\n\
			<div class="media-frame mode-select wp-core-ui hide-menu">\n\
				<div class="media-frame-title">\n\
					<h1>' + params.title + '<span class="dashicons dashicons-arrow-down"></span></h1>\n\
				</div>\n\
				<div class="media-frame-router">\n\
					<div class="media-router">' + tabs + '</div>\n\
				</div>\n\
				<div class="media-frame-content"><div class="Awe_spiner"></div>' + content + '</div>' + footer + '\n\
			</div>\n\
		</div>\n\
                    </div>\n\
                    <div class="media-modal-backdrop"></div>\n\
            </div>';
                $("body").append(html);

                //Print first tab
                var flag = false;
                for (var id_content in params.tabs) {
                    if (flag == false) {
                        window[params.addon].print(id_content);
                        flag = true;
                    }
                }
            }

            if (Object.keys(params.valueSelected).length) {

                this.find('.Awe_insert').removeAttr('disabled');

                /*
                 *@Print preview list 
                 */
                var Addon = window[Awe_dialog.addon];
                if (typeof Addon.printReview == 'function') {
                    Addon.printReview();
                }

            } else {
                Awe_dialog.find('.clear-selection').hide();
                Awe_dialog.find('.edit-selection').hide();
            }
        }
    };
})(jQuery);


var Awe_icon = {};
(function ($) {
    'use strict';

    /*Event group filter*/
    $(document).on('click', '.Awe_icon ul.group li a', function (e) {
        var $this = $(this);
        var filter = $this.attr('href').replace('#', '');
        $(".Awe_icon ul.group li a").removeClass('selected');
        $this.addClass('selected');
        if (filter == "all-icons") {
            $(".Awe_icon ul.list li").show();
        } else {
            $(".Awe_icon ul.list li").hide();
            $(".Awe_icon ul.list li." + filter).show();
        }


        e.preventDefault();
    });

    /*
     *@Awe dialog by Vu tuan 
     */
    Awe_icon = {
        values: {},
        print: function (id_content) {

            var url = Awe.themeurl + '/Framework/asset/icons/data/';
            Awe_dialog.showWait();
            $.ajax({
                url: url + id_content + ".json",
                dataType:'json',
                success: function (data) {

                    data = Awe_icon.reFormat(data);
                    var element = '';
                    var group = '';
                    $.each(data.icons, function (key, item) {

                        var selected = (Awe_icon.values[item.id]) ? 'selected' : ''; //Active selected item

                        element += '<li class="' + item.categories + '">\n\
                                        <a href="#" class="' + selected + '" data-id="' + item.id + '" data-data="' + item.name + '" title="' + item.name + '">\n\
                                            <button class="list-check"><span></span></button>\n\
                                            <span class="list-icon"><i class="' + item.id + '"></i></span><span class="name">' + item.name + '</span>\n\
                                            <span class="filters" style="opacity: 0;">' + item.filter + '</span>\n\
                                        </a>\n\
                                    </li>';
                    });
                    $.each(data.groups, function (key, item) {
                        group += '<li><a href="#' + key + '">' + item + '</a></li>';
                    });
                    Awe_dialog.setContent(id_content,
                            '<div class="list-wrapper"><ul class="Awe_dialog_list list">' + element + '</ul></div>\n\
                                <div class="media-sidebar">\n\
                                    <h3>Search icons</h3>\n\
                                    <input class="search" type="search" placeholder="Search icons..."/>\n\
                                    <h3>Search by category</h3>\n\
                                    <ul class="group">' + group + '</ul>\n\
                            </div>');
                    Awe_dialog.setCounter(Object.keys(Awe_icon.values).length);
                    new List("awe_" + id_content, {page: 750, valueNames: ['name', 'filters']});
                    Awe_dialog.hideWait();
                }
            });
        },
        printSelected: function () {

            var element = '';
            $.each(this.values, function (id, name) {
                element += '<li>\n\
                                        <a href="#" class="selected" data-id="' + id + '" title="' + name + '">\n\
                                            <button class="list-check"><span></span></button>\n\
                                            <span class="list-icon"><i class="' + id + '"></i></span><span class="name">' + name + '</span>\n\
                                        </a>\n\
                                    </li>';
            });
            var html = '<div class="list-wrapper"><ul class="list">' + element + '</ul></div>';
            Awe_dialog.setContent('itemselected', html);
        },
        printReview: function () {
            var element = '';
            $.each(this.values, function (id, name) {
                element += '<li class="item-preview" title="' + name + '"><i class="' + id + '"></i></li>';
            });
            Awe_dialog.find('.selection-view ul').html(element);
        },
        reFormat: function (data) {
            var groups = {
                'all-icons': 'All icons'
            };
            $.each(data.icons, function (i, item) {


                if (!item.filter) {
                    item.filter = item.id;
                } else {
                    item.filter = item.filter.join(' ')
                }

                if (item.categories) {
                    $.each(item.categories, function (j, jitem) {
                        var key = Awe.replaceAll(jitem,' ', '-').toLowerCase();
                        groups[key] = jitem;
                        item.categories[j] = key;
                    });
                    item.categories = item.categories.join(' ');
                } else {
                    item.categories = 'all-icons';
                }
            });
            return {
                groups: groups,
                icons: data.icons
            };
        },
        onClear: function (e) {
            Awe_dialog.find(".list a.selected").removeClass('selected');
            this.values = {};
            Awe_dialog.setCounter(Object.keys(this.values).length);
        },
        onInsert: function (e) {

        },
    };
})(jQuery);
