<?php
if (!defined( 'ABSPATH' ) ) die( '-1' );

abstract class awe_shortcode {

	protected $icon = '';

	protected function get_resource( $file, $path = '' ) {
		if ( $path == '' ) {
			$path = get_template_directory_uri() . '/awe_shortcode/shortcode/' . get_class( $this ) . '/';
		} else if ( $path == 'css' ) {
			$path = get_template_directory_uri() . '/awe_shortcode/assets/css/';
		} else if ( $path == 'js' ) {
			$path = get_template_directory_uri() . '/awe_shortcode/assets/js/';
		} else if ( $path == 'images' ) {
			$path = get_template_directory_uri() . '/awe_shortcode/assets/images/';
		} else if ( $path == 'assets' ) {
			$path = get_template_directory_uri() . '/awe_shortcode/assets/';
		} else if ( $path == 'vendors' ) {
			$path = get_template_directory_uri() . '/awe_shortcode/assets/vendors/';
		}
		return $path . $file;
	}

	public function load_script( $name = '', $url = '', $deps = '' ) {
		if ( '' == $name ) {
			$name = get_class( $this );
		}
		if ( '' == $url ) {
			$url = get_template_directory_uri() . '/awe_shortcode/shortcode/' . get_class( $this ) . '/script.js';
		}
		wp_enqueue_script( $name, $url, $deps, '1.0' );
	}

	public function getId() {
		return (int) mt_rand( 0, 100 );
	}

	protected function animation() {
		return $array = array(
			__( 'No', 'hillter' ) => '',
			__( 'FadeIn', 'hillter' ) =>'fadeIn',
			__( 'FadeInDown', 'hillter' ) => 'fadeInDown',
			__( 'FadeInDownBig', 'hillter' ) => 'fadeInDownBig',
			__( 'FadeInLeft', 'hillter' ) => 'fadeInLeft',
			__( 'FadeInLeftBig', 'hillter' ) => 'fadeInLeftBig',
			__( 'FadeInRight', 'hillter' ) => 'fadeInRight',
			__( 'FadeInRightBig', 'hillter' ) => 'fadeInRightBig',
			__( 'FadeInUp', 'hillter' ) => 'fadeInUp',
			__( 'FadeInUpBig', 'hillter' ) => 'fadeInUpBig',
			__( 'FadeInhalf-text', 'hillter' ) => 'fadeInhalf-text',
			__( 'FadeInhalf-symbolBig', 'hillter' ) => 'fadeInhalf-symbolBig',
			__( 'BounceIn', 'hillter' ) => 'bounceIn',
			__( 'BounceInDown', 'hillter' ) => 'bounceInDown',
			__( 'BounceInLeft', 'hillter' ) => 'bounceInLeft',
			__( 'BounceInRight', 'hillter' ) => 'bounceInRight',
			__( 'BounceInUp', 'hillter' ) => 'bounceInUp',
			__( 'Flash', 'hillter' ) => 'flash',
			__( 'Pulse', 'hillter' ) => 'pulse',
			__( 'RubberBand', 'hillter' ) => 'rubberBand',
			__( 'Shake', 'hillter' ) => 'shake',
			__( 'Swing', 'hillter' ) => 'swing',
			__( 'Tada', 'hillter' ) => 'tada',
			__( 'Wobble', 'hillter' ) => 'wobble',
			__( 'Flip', 'hillter' ) => 'flip',
			__( 'FlipInX', 'hillter' ) => 'flipInX',
			__( 'FlipInY', 'hillter' ) => 'flipInY',
			__( 'LightSpeedIn', 'hillter' ) => 'lightSpeedIn',
			__( 'RotateIn', 'hillter' ) => 'rotateIn',
			__( 'RotateInDownLeft', 'hillter' ) => 'rotateInDownLeft',
			__( 'RotateInDownRight', 'hillter' ) => 'rotateInDownRight',
			__( 'RotateInUpLeft', 'hillter' ) => 'rotateInUpLeft',
			__( 'RotateInDownRight', 'hillter' ) => 'rotateInUpRight',
			__( 'SlideInDown', 'hillter' ) => 'slideInDown',
			__( 'SlideInLeft', 'hillter' ) => 'slideInLeft',
			__( 'SlideInRight', 'hillter' ) => 'slideInRight',
			__( 'RollIn', 'hillter' ) => 'rollIn',
		);
	}

	protected function animation_class( $animation ) {
		if ( $animation ) {
			return 'wow ' . $animation . ' animated';
		} else {
			return '';
		}
	}

	protected function icon( $icon = 'shortcode.png' ) {
		return $this->get_resource( $icon, 'images' );
	}

	public function custom_shortcode( $tag, $func ) {
		global $shortcode_tags;

		if ( is_callable( $func) ) {
			$shortcode_tags[ $tag ] = $func;
		}
	}

	abstract function awe_vc_shortcode();

	abstract function awe_render_html( $atts, $content= '' );

	public function awe_show_admin_notice() {
		if ( ! defined( 'WPB_VC_VERSION' ) ) {
			?>
			<div class="updated">
				<p><strong>Hillter Theme</strong> requires <strong><a href="#" target="_blank">Visual Composer</a></strong> plugin to be installed and activated on your site</p>
			</div>';
			<?php
		}
	}

	public function order_way_values(){
		return $order_way_values = array(
			'',
			__( 'Descending', 'js_composer' ) => 'DESC',
			__( 'Ascending', 'js_composer' ) => 'ASC',
		);
	}

	public function order_by_values(){
		return $order_by_values = array(
			'',
			__( 'Date', 'js_composer' ) => 'date',
			__( 'ID', 'js_composer' ) => 'ID',
			__( 'Author', 'js_composer' ) => 'author',
			__( 'Title', 'js_composer' ) => 'title',
		);
	}
}


function awe_save_postmeta( $meta_key = '', $meta_value = '', $post_id = 0, $echo = true ) {
   
	$meta_key = isset( $_POST['meta_key'] ) ? sanitize_key( $_POST['meta_key'] ) : $meta_key;
	$meta_value = isset( $_POST['meta_value'] ) ? $_POST['meta_value'] : $meta_value;
	$post_id = isset( $_POST['post_id'] ) ? absint( $_POST['post_id'] ) : $post_id;
	$meta_id = (isset( $_POST['meta_id'] ) && $_POST['meta_id'] != '' ) ? absint( $_POST['meta_id'] ) : 0;

	$meta_value = str_replace( array( '\\\'', '\\"', '\\\\' ), array( '\'', '"', '\\' ), $meta_value );
	$arr = '-'; 
	if ( $meta_key != '' && $meta_value != '' && $post_id > 0 ) {
		global $wpdb;
		$count = $wpdb->get_var( $wpdb->prepare( "SELECT COUNT(*) FROM $wpdb->postmeta WHERE meta_id = %d", absint( $meta_id ) ) );
		if ( $count > 0 ) {
			$wpdb->update(
				$wpdb->postmeta,
				array(
					'post_id'       => $post_id,
					'meta_key'      => $meta_key,
					'meta_value'    => $meta_value
				),
				array( 'meta_id' => $meta_id ),
				array( '%d', '%s', '%s' ),
				array( '%d' )
			);
			$arr = array(
				'status' => 'update_success',
				'message' => 'Saved'
			);
		   

		} else {
			$wpdb->insert(
				$wpdb->postmeta,
				array(
					'post_id'       => $post_id,
					'meta_key'      => $meta_key,
					'meta_value'    => $meta_value
				),
				array( '%d', '%s', '%s' )
			);
			$arr = array(
				'status'    => 'insert_success',
				'message'   => $wpdb->insert_id
			);
		}
		if( $echo == true ) {
			echo json_encode( $arr );
			die();
		} else {
			return $arr;
		}
	}
}

add_action( 'wp_ajax_awe_save_postmeta', 'awe_save_postmeta' );
