(function($) {
	"use strict";

	$(document).ready(function() {

		var $singleFrame,
			$galleryFrame,
			$editGalleryFrame;

		/**** Single image upload *****/
		$(".single-image-upload-btn").on('click', function() {

			var $btn = $(this);
			var $imageView = $btn.parent().prev();
			var $input = $btn.parent().next();

			// console.log(wp.media.view.l10n);

			// if frame exists
			// if ($singleFrame) {
			// 	$singleFrame.open();
			// 	return;
			// }

			// load new frame
			$singleFrame = wp.media({
				title: wp.media.view.l10n.chooseImage,
				button: {
					text: wp.media.view.l10n.select,
				},
				multiple: false,
			});

			// when image selected
			$singleFrame.on('select', function() {
				var attach = $singleFrame.state().get('selection').first().toJSON();
				$imageView.html('<img src="' + attach.url + '">');
				$input.val(attach.url);
			});

			$singleFrame.open();

		});


		/***** Single image remove *****/
		$(".single-image-remove-btn").on('click', function() {
			var $btn = $(this);
			var $imageView = $btn.parent().prev();
			var $input = $btn.parent().next();

			$imageView.html('<img src="' + $btn.data('no-image') + '">');
			$input.val('');
		});



		/***** Gallery upload *****/
		$(".gallery-upload-btn").on('click', function() {
			var $btn = $(this);
			var $imageView = $btn.parent().prev();
			var $inputShortcode = $btn.parent().next();

			// attachment id
			var idList = [];

			// if frame exists
			// if ($galleryFrame) {
			// 	$galleryFrame.open();
			// 	return;
			// }

			// load new frame
			$galleryFrame = wp.media({
				button: {
					text: wp.media.view.l10n.select,
				},
				multiple: true,
				frame: 'post',
				state: 'gallery',
			});

			$galleryFrame.state('gallery-edit').on('update', function(select) {
				// Get shortcode
				var sc = wp.media.gallery.shortcode(select).string();

				$imageView.html('');

				for (var i = 0; i < select.models.length; i++) {
					// console.log(select.models[i]);
					var imgId = select.models[i].id;
					var imgUrl = select.models[i].attributes.url;

					// add image item to imageView
					var item = '<img src="' + imgUrl + '"><input type="hidden" name="' + $btn.data('key') + '[images][' + imgId + ']" value="' + imgUrl + '">';
					$imageView.append(item);

					// Add id to idList
					idList.push(imgId);
				}

				// store shortcode
				$inputShortcode.val(sc);

				// store list id
				$btn.next().attr('data-list-id', idList.join(','));

			});

			$galleryFrame.open();


		});


		/***** Edit gallery *****/
		$(".gallery-edit-btn").on('click', function() {
			var $btn = $(this);
			var $imageView = $btn.parent().prev();
			var $inputShortcode = $btn.parent().next();

			var idList = [];
			var oldIdList = $btn.attr('data-list-id');


			if (!oldIdList.length) return;

			oldIdList = oldIdList.split(',');

			// if frame exists
			// if ($editGalleryFrame) {
			// 	$editGalleryFrame.open();
			// 	return;
			// }

			// load new frame
			$editGalleryFrame = wp.media({
				button: {
					text: wp.media.view.l10n.select,
				},
				multiple: true,
				frame: 'post',
				state: 'gallery-edit',
			});

			// load current attachments
			$editGalleryFrame.on('open', function() {
				var aweLibrary = $editGalleryFrame.state('gallery-edit').get('library');
				var attach;

				// Load each attachment & add to library
				for (var i = 0; i < oldIdList.length; i++) {
					attach = wp.media.attachment(oldIdList[i]);
					attach.fetch();
					aweLibrary.add(attach ? [attach] : []);
				}
			});

			$editGalleryFrame.state('gallery-edit').on('update', function(select) {
				// Get shortcode
				var sc = wp.media.gallery.shortcode(select).string();

				$imageView.html('');

				for (var i = 0; i < select.models.length; i++) {
					// console.log(select.models[i]);
					var imgId = select.models[i].id;
					var imgUrl = select.models[i].attributes.url;

					// add image item to imageView
					var item = '<img src="' + imgUrl + '"><input type="hidden" name="' + $btn.prev().data('key') + '[images][' + imgId + ']" value="' + imgUrl + '">';
					$imageView.append(item);

					// Add id to idList
					idList.push(imgId);
				}

				// store shortcode
				$inputShortcode.val(sc);

				// store list id
				$btn.attr('data-list-id', idList.join(','));

			});

			$editGalleryFrame.open();
			// console.log("aaaa");

		});


		/***** Remove gallery *****/
		$(".gallery-remove-btn").on('click', function() {
			var $btn = $(this);
			var $imageView = $btn.parent().prev();
			var $inputShortcode = $btn.parent().next();

			$imageView.html('<img src="' + $btn.data('no-image') + '">');
			$inputShortcode.val('');
			$btn.prev().attr('data-list-id', '');
		});



		/***** Add Video *****/
		$(".video-add-btn").on('click', function() {
			var $btn = $(this);
			var $videoView = $btn.parent().prev();
			var $inputUrl = $btn.prev();
			var $inputEmbed = $btn.parent().next();
			var embedUrl;
			var url = $inputUrl.val();

			// if empty url input
			if (!url) return;

			if (aweIsYoutube(url)) { // youtube video

				var youtubeData = aweGetYoutubeData(url);
				embedUrl = youtubeData['embed'];

			} else if (aweIsVimeo(url)) { // vimeo url
				
				var vimeoData = aweGetVimeoData(url);
				embedUrl = vimeoData['embed'];

			} else {
				alert("Please use Youtube or Vimeo video");
			}

			if (embedUrl) {
				$videoView.html('<div class="embed-responsive embed-responsive-16by9"><iframe class="embed-responsive-item" src="' + embedUrl + '"></iframe></div>');
				$inputEmbed.val(embedUrl);
			}

		});


		/***** Remove Video *****/
		$(".video-remove-btn").on('click', function() {
			var $btn = $(this);
			var $videoView = $btn.parent().prev();
			var $inputUrl = $btn.prev().prev();
			var $inputEmbed = $btn.parent().next();

			$videoView.html('<img src="' + $btn.data('no-video') + '">');
			$inputUrl.val('');
			$inputEmbed.val('');
		});



		/***** Add audio *****/
		$(".audio-add-btn").on('click', function() {
			var $btn = $(this);
			var $audioView = $btn.parent().prev();
			var $inputUrl = $btn.prev();
			var $inputAutoplay = $btn.parent().find(':checkbox');
			var url = $inputUrl.val();

			if (url) {
				var maxheight = (url.indexOf("/sets/") != -1) ? "450px" : "160px";
				var autoplay = $inputAutoplay.is(':checked') ? 'true' : 'false';
				$audioView.html('<iframe width="100%" height="' + maxheight + '" scrolling="no" frameborder="no" src="https://w.soundcloud.com/player/?url=' + url + '&amp;auto_play=' + autoplay + '&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true"></iframe>');
			}

		});


		/***** Remove audio *****/
		$(".audio-remove-btn").on('click', function() {
			var $btn = $(this);
			var $audioView = $btn.parent().prev();
			var $inputUrl = $btn.prev().prev();
			var $inputAutoplay = $btn.parent().find(':checkbox');

			$audioView.html('<img src="' + $btn.data('no-audio') + '">');
			$inputUrl.val('');
			$inputAutoplay.prop('checked', false);
		});

	});


	function aweIsYoutube(url) {
		if (url.indexOf('youtube.com') > -1)
            return true;
        if (url.indexOf('youtu.be') > -1)
            return true;
        return false;
	}

	function aweIsVimeo(url) {
		if (url.indexOf('vimeo.com') > -1)
            return true
        return false;
	}

	function aweGetYoutubeData(url) {
		var id = url.match("[\\?&]v=([^&#]*)");
		var data = {
			embed: '//www.youtube.com/embed/' + id[1],
			image: 'http://i.ytimg.com/vi/' + id[1] + '/hqdefault.jpg'
		};
		return data;
	}

	function aweGetVimeoId(url) {
        var id_vimeo, m;
		if (url.search('channels') != -1) {
            m = url.match(/^.+vimeo.com\/channels\/(.*\/)?([^#\?]*)/);
        } else {
            m = url.match(/^.+vimeo.com\/(.*\/)?([^#\?]*)/);
        }

        id_vimeo = m ? m[2] || m[1] : null;
        return id_vimeo;
	}

	function aweGetVimeoData(url) {
		var id = aweGetVimeoId(url);
		var data = {
			embed: 'https://player.vimeo.com/video/' + id,
		};
		return data;
	}

})(jQuery);