<?php

class AWE_Event {

	public function __construct() {
		// Load assets
		add_action( 'admin_enqueue_scripts', array( $this, 'load_assets' ) );

		// Add meta box
		add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ) );
		add_action( 'save_post', array( $this, 'save' ) );
		// add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ) );
		
		// Custom list table column
		add_filter( 'manage_event_posts_columns', array( $this, 'manage_columns' ) );
		add_action( 'manage_event_posts_custom_column', array( $this, 'manage_column_date_content' ), 10, 2 );
		add_filter( 'manage_edit-event_sortable_columns', array( $this, 'manage_column_date_sortable' ) );
		add_filter( 'request', array( $this, 'manage_column_date_sortable_request' ) );
	}


	public function load_assets() {
		$screen = get_current_screen();
		if ( $screen->id == 'event' || $screen->id == 'edit-event' ) {
			wp_enqueue_script( 'jquery-ui-datepicker' );
			wp_enqueue_script( 'awe-event-js', get_template_directory_uri() . '/awe-event/assets/js/scripts.js', array( 'jquery-ui-datepicker' ), false, true );
			wp_enqueue_style( 'awe-jqueryui', get_template_directory_uri() . '/Framework/asset/css/jquery-ui.css' );
		}
	}


	public function add_meta_box( $post_type ) {
		$post_types = array( 'event' );
		if ( in_array ( $post_type, $post_types ) ) {
			add_meta_box( 'awe-event-metabox', __( 'Event', 'hillter' ), array( $this, 'render' ), $post_type, 'normal', 'low' );
		}
	}


	public function save( $post_id ) {
		// Check if our nonce is set.
		if (!isset($_POST['awe_event_metabox_nonce_field']))
			return $post_id;

		$nonce = $_POST['awe_event_metabox_nonce_field'];

		// Verify that the nonce is valid.
		if (!wp_verify_nonce($nonce, 'awe_event_metabox_nonce'))
			return $post_id;

		// If this is an autosave
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
			return $post_id;

		// Check the user's permissions.
		if (!current_user_can('edit_post', $post_id))
			return $post_id;

		// OK
		
		$data = isset( $_POST['awe_event_metabox'] ) ? ( array ) $_POST['awe_event_metabox'] : array();
		foreach ( $data as $k => $v ) {
			update_post_meta( $post_id, 'awe_event_metabox_' . $k, esc_html( $v ) );
		}
	}


	public function render( $post ) {
		wp_nonce_field('awe_event_metabox_nonce', 'awe_event_metabox_nonce_field');
		$date = get_post_meta( $post->ID, 'awe_event_metabox_date', true );
		$time = get_post_meta( $post->ID, 'awe_event_metabox_time', true );
		$location = get_post_meta( $post->ID, 'awe_event_metabox_location', true );
		?>

			<div id="awe-event-metabox">
				<table width="100%">
					<tr>
						<th align="left">
							<label for="awe-event-metabox-date"><?php _e( 'Event date', 'hillter' ); ?></label>
						</th>
						<td align="left">
							<input type="text" name="awe_event_metabox[date]" id="awe-event-metabox-date" value="<?php echo esc_html( $date ); ?>">
						</td>
					</tr>

					<tr>
						<th align="left">
							<label for="awe-event-metabox-time"><?php _e( 'Event time', 'hillter' ); ?></label>
						</th>
						<td align="left">
							<input type="text" name="awe_event_metabox[time]" id="awe-event-metabox-time" value="<?php echo esc_html( $time ); ?>">
						</td>
					</tr>

					<tr>
						<th align="left">
							<label for="awe-event-metabox-location"><?php _e( 'Event location', 'hillter' ); ?></label>
						</th>
						<td align="left">
							<input type="text" name="awe_event_metabox[location]" id="awe-event-metabox-location" value="<?php echo esc_html( $location ); ?>">
						</td>
					</tr>
				</table>
			</div>

		<?php

	}


	public function manage_columns( $column ) {
		if ( isset( $column['date'] ) ) {
			unset( $column['date'] );
		}
		$column['event_date'] = __( 'Event date', 'hillter' );
		return $column;
	}


	public function manage_column_date_content( $column_name, $post_id ) {
		if ( $column_name == 'event_date' ) {
			$event_date = get_post_meta( $post_id, 'awe_event_metabox_date', true );
			if ( $event_date ) {
				echo date( get_option( 'date_format' ), strtotime( $event_date ) );
			}
		}
	}


	public function manage_column_date_sortable( $column ) {
		$column['event_date'] = 'event_date';
		return $column;
	}


	public function manage_column_date_sortable_request( $vars ) {
		if ( isset( $vars['orderby'] ) && 'event_date' == $vars['orderby'] ) {
			$vars = array_merge( $vars, array(
				'meta_key' => 'awe_event_metabox_date',
				'orderby' => 'meta_value'
			) );
		}

		return $vars;
	}

}