<?php

class AWE_Meta_box {

    public function __construct() {
        add_action('add_meta_boxes', array($this, 'awe_meta_box'), 10);
        add_action('save_post', array($this, 'save_box_sidebar'));
    }

    public function awe_meta_box() {
        add_meta_box('awe-meta-box-sidebar', __('Sidebar', 'hillter'), array($this, 'render_html_box_sidebar'), array('post', 'page'), 'side', 'default', '');
    }

    public function render_html_box_sidebar($post) {
        $type = get_post_meta($post->ID, "sidebar_type", true);
        $name = get_post_meta($post->ID, "sidebar_name", true);
        if (empty($name)) {
            $name = 'main-sidebar';
        }
        ?>
        <link rel='stylesheet'  href='<?php echo AWE_WIDGET_AUTO ?>/asset/css/awe_sidebar.css' type='text/css' />
        <div class="inside">
            <p><strong>Layout</strong></p>
            <label for="sidebar_type" class="screen-reader-text">Parent</label>
            <p>Sidebar layout.</p>
            <select id="parent_id" name="sidebar_type">
                <option <?php if ($type == "right") echo "selected='selected'" ?> value="right">Right Sidebar</option>
                <option <?php if ($type == "left") echo "selected='selected'" ?> value="left">Left Sidebar</option>
                <option <?php if ($type == "none") echo "selected='selected'" ?> value="none">No Sidebar</option>
            </select>
        </div>
        <div class="inside">
            <label for="sidebar_name" class="screen-reader-text"><?php _e("Sidebar setting", 'hillter') ?></label>
            <p>Select sidebar.</p>
            <select name="sidebar_name">
                <?php
                foreach ($GLOBALS['wp_registered_sidebars'] as $sidebar) {
                    ?>
                    <option <?php selected($name, $sidebar['id']) ?> value="<?php echo esc_attr($sidebar['id']); ?>"><?php print $sidebar['name']; ?></option>
                    <?php
                }
                ?>
            </select>
        </div>

        <script>
            (function($) {
                "use strict";

                $(document).ready(function() {
                    // choose blog layout
                    $(".awe-layout-choose li").on("click", function() {
                        $(".awe-layout-choose li.chosen").removeClass('chosen');
                        $(this).addClass('chosen');
                        $(this).parent().parent().find("input").val($(this).attr("data-name"));
                        return false;
                    });
                });
            })(jQuery);
        </script>
        <?php
    }

    public function save_box_sidebar($post_id) {
        if (isset($_POST['sidebar_type'])) {
            update_post_meta($post_id, 'sidebar_type', $_POST['sidebar_type']);
        }
        if (isset($_POST['sidebar_name'])) {
            update_post_meta($post_id, 'sidebar_name', $_POST['sidebar_name']);
        }
    }

}

// new Meta_box();
