<?php

Class AWE_Created_widget {

    var $paths = array();
    var $sidebars = array();
    var $stored = "";

    public function __construct() {
        add_action('load-widgets.php', array(&$this, 'load_assets'), 5);

        $this->paths['css'] = AWE_WIDGET_AUTO . "/asset/css/";
        $this->paths['js'] = AWE_WIDGET_AUTO . "/asset/js/";
        $this->title = __('New Sidebar', 'hillter');
        $this->stored = 'awe_sidebars';
        add_action('widgets_init', array(&$this, 'register_custom_sidebars'), 1000);
        add_action('wp_ajax_awe_ajax_delete_custom_sidebar', array(&$this, 'awe_delete_sidebar_area'), 1000);
    }

    public function file_create_widget() {
        include AWE_WIDGET_ROOT . '/lib/controller/created_widget.php';
    }

    //load backend css, js and add hooks to the widget page
    public function load_assets() {
        add_action('admin_print_scripts', array(&$this, 'awe_template_add_widget_field'));
        add_action('load-widgets.php', array(&$this, 'awe_add_sidebar_area'), 100);

        wp_register_script('awe_sidebar', $this->paths['js'] . 'awe_sidebar.js', array( 'jquery' ));
        wp_enqueue_script('awe_sidebar');
        wp_register_style('awe_sidebar', $this->paths['css'] . 'awe_sidebar.css');
        wp_enqueue_style('awe_sidebar');
    }

    public function awe_template_add_widget_field() {
        $nonce = wp_create_nonce('awe-delete-custom-sidebar-nonce');
        $nonce = '<input type="hidden" name="awe-delete-custom-sidebar-nonce" value="' . $nonce . '" />';

        echo "\n<script type='text/html' id='awe-tmpl-add-widget'>";
        echo "\n  <form class='awe-add-widget' action='' method='POST'>";
        echo "\n  <h3>" . $this->title . "</h3>";
        echo "\n    <span class='awe_style_wrap'><input type='text' value='' placeholder = '" . __('Enter sidebar name', 'hillter') . "' name='add_sidebar' /></span>";
        echo "\n    <input class='button-primary' type='submit' value='" . __('Create New', 'hillter') . "' />";
        echo "\n    " . $nonce;
        echo "\n  </form>";
        echo "\n</script>\n";
    }

    function awe_add_sidebar_area() {
        if (!empty($_POST['add_sidebar'])) {

            $this->sidebars = get_option($this->stored);
            $name = $this->awe_get_name($_POST['add_sidebar']);
            if (empty($this->sidebars)) {
                $this->sidebars = array($name);
            } else {
                $this->sidebars = array_merge($this->sidebars, array($name));
            }
            update_option($this->stored, $this->sidebars);
            wp_redirect(admin_url('widgets.php'));
            die();
        }
    }

    //register custom sidebar areas
    function register_custom_sidebars() {

        if (empty($this->sidebars))
            $this->sidebars = get_option($this->stored);
        $args = array(
            'before_widget' => '<div id="%1$s" class="widget clearfix %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widgettitle">',
            'after_title' => '</h3>'
        );

        $args = apply_filters('awe_custom_widget_args', $args);

        if (is_array($this->sidebars)) {
            foreach ($this->sidebars as $sidebar) {
                if ($sidebar != "") {
                    $args['name'] = $sidebar;
                    $args['id'] = strtolower(str_replace(" ", "-", $sidebar));
                    $args['class'] = 'awe-custom';
                    register_sidebar($args);
                }
            }
        }
    }

    //delete a sidebar area from the database
    function awe_delete_sidebar_area() {
        check_ajax_referer('awe-delete-custom-sidebar-nonce');

        if (!empty($_POST['name'])) {
            $name = stripslashes($_POST['name']);
            $this->sidebars = get_option($this->stored);

            if (($key = array_search($name, $this->sidebars)) !== false) {
                unset($this->sidebars[$key]);
                update_option($this->stored, $this->sidebars);
            }
        }
        die();
    }

    //checks the user submitted name and makes sure that there are no colitions
    function awe_get_name($name) {
        if (empty($GLOBALS['wp_registered_sidebars']))
            return $name;

        $taken = array();
        foreach ($GLOBALS['wp_registered_sidebars'] as $sidebar) {
            $taken[] = $sidebar['name'];
        }

        if (empty($this->sidebars))
            $this->sidebars = array();
        $taken = array_merge($taken, $this->sidebars);

        if (in_array($name, $taken)) {
            $counter = substr($name, -1);
            $new_name = "";

            if (!is_numeric($counter)) {
                $new_name = $name . " 1";
            } else {
                $new_name = substr($name, 0, -1) . ((int) $counter + 1);
            }

            $name = $this->awe_get_name($new_name);
        }

        return $name;
    }

}
