<?php
/*
 * author: awethemes
 * author uri: awethemes.com
 * date: 04/25/2015
 * dae: 11:30 am
 */


define( 'WO_THEMENAME', '' );
// require_once( AWE_ROOT_DIR . '/lib/mailchimp/MailChimp.php' );

// Setup Widget

class AWEWidgets extends AweFramework {

	const AWEW_WIDGETS = 'awew-widgets';

	public function __construct() {
		// register_widget( 'AWE_Footer_Info' );
		// register_widget( 'AWE_Facebook_Page' );
		// register_widget( 'Awe_instagram_widget' );
		// register_widget( 'Awe_Widget_Recent_Comments' );
		register_widget( 'AWE_Follow_Us' );
		// register_widget( 'Awe_Mailchimp_widget' );
		register_widget( 'Awe_Flickr_widget' );
		register_widget( 'Awe_slide_image' );
		register_widget( 'awe_recent_posts_widget' );
		register_widget( 'AWE_Event_Widget' );
		// register_widget( 'awe_recent_event_widget' );
	}

}


/**
 * Awe event widget
 */
class AWE_Event_Widget extends WP_Widget {

	public function __construct() {
		$widget_ops = array(
			'classname'	=> 'awe-event-widget',
			'description'	=> __( 'Display events', 'hillter' ),
		);
		parent::__construct( 'awe-event', __( 'Awe Event', 'hillter' ), $widget_ops );
	}


	public function widget( $args, $instance ) {
		$instance = wp_parse_args( $instance, array(
			'title'	=> '',
			'cat'	=> '',
			'num'	=> 3
		) );

		$title = strip_tags( $instance['title'] );
        $title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

        $cat = intval( $instance['cat'] );
        $num = !empty( $instance['num'] ) ? absint( $instance['num'] ) : 3;

        print $args['before_widget'];
        if ( $title ) {
        	print $args['before_title'] . $title . $args['after_title'];
        }

        // Query
        $query_args = array(
        	'post_type'	=> 'event',
        	'posts_per_page'	=> $num,
        	'meta_key'		=> 'awe_event_metabox_date',
        	'orderby'		=> 'meta_value',
        	'order'			=> 'asc',
        );

        if ( $cat ) {
        	$query_args['tax_query'] = array(
        		array(
        			'taxonomy'	=> 'event-category',
        			'field'	=> 'term_id',
        			'terms'	=> $cat,
        		)
        	);
        }

        $the_query = new WP_Query( $query_args );
        if ( $the_query->have_posts() ) {
        	?>
        		<ul>
        			<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
        				<?php
        				$date = get_post_meta( get_the_ID(), 'awe_event_metabox_date', true ) ? strtotime( get_post_meta( get_the_ID(), 'awe_event_metabox_date', true ) ) : '';
        				$time = get_post_meta( get_the_ID(), 'awe_event_metabox_time', true ) ? esc_html( get_post_meta( get_the_ID(), 'awe_event_metabox_time', true ) ) : '';
        				?>
	                    <li>
	                    	<?php if ( $date ) : ?>
		                        <span class="event-date">
		                            <strong><?php echo date_i18n( 'd', $date ); ?></strong>
		                            <?php echo strtoupper( date_i18n( 'M', $date ) ); ?>
		                        </span>
		                    <?php endif; ?>
	                        <div class="text">
	                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
	                            <?php if ( $time ) : ?>
	                            	<span class="date"><?php printf( __( 'at %s', 'hillter' ), esc_html( $time ) ); ?></span>
	                            <?php endif; ?>
	                        </div>
	                    </li>
	                <?php endwhile; wp_reset_postdata(); ?>
                </ul>
        	<?php
        }
        print $args['after_widget'];
	}


	public function form( $instance ) {
		$instance = wp_parse_args( $instance, array(
			'title'	=> '',
			'cat'	=> '',
			'num'	=> 3
		) );

		$title = strip_tags( $instance['title'] );

        $cat = intval( $instance['cat'] );
        $num = !empty( $instance['num'] ) ? absint( $instance['num'] ) : 3;

        $list_cats = apply_filters( 'awe_list_event_categories', get_terms( 'event-category', 'hide_empty=1' ) );
        ?>

        	<p>
                <label for="<?php print $this->get_field_id('title'); ?>"><?php _e('Title', 'hillter'); ?></label>
                <input class="widefat" id="<?php print $this->get_field_id('title'); ?>" name="<?php print $this->get_field_name('title'); ?>" type="text" value="<?php print $title; ?>" />
            </p>

            <p>
                <label for="<?php print $this->get_field_id('cat'); ?>"><?php _e('Category', 'hillter'); ?></label>
                <select class="widefat" id="<?php print $this->get_field_id('cat'); ?>" name="<?php print $this->get_field_name('cat') ?>">
                    <option value="0" <?php selected($cat, 0); ?>><?php _e('All categories', 'hillter'); ?></option>
                    <?php foreach ($list_cats as $v) : ?>
                        <option value="<?php echo absint($v->term_id); ?>" <?php selected($cat, $v->term_id); ?>><?php echo strip_tags($v->name); ?></option>
                    <?php endforeach; ?>
                </select>
            </p>
            
            <p>
                <label for="<?php print $this->get_field_id('num'); ?>"><?php _e('Numbers of post', 'hillter'); ?></label>
                <input type="number" class="widefat" id="<?php print $this->get_field_id('num'); ?>" name="<?php print $this->get_field_name('num'); ?>" value="<?php echo absint($num); ?>" />
            </p>

        <?php
	}


	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['cat'] = strip_tags( $new_instance['cat'] );
		$instance['num'] = $new_instance['num'];
		return $instance;
	}

}



/**
 * Awe : Footer Info
 */
class AWE_Footer_Info extends WP_Widget {

	public function __construct() {
		$widget_ops = array( 'classname' => 'widget_footer_info', 'description' => __( 'Footer Information', 'hillter' ) );
		parent::__construct( 'AWE_Footer_Info', __( 'Awe : Footer Info', 'hillter' ), $widget_ops );
	}

	public function form($instance) {
		$defaults = array( 'title' => __( 'Find us on Facebook', 'hillter' ), 'page_url' => '', 'width' => '292', 'color_scheme' => 'light', 'show_faces' => 'on', 'show_stream' => false, 'show_header' => false );
		$instance = wp_parse_args( (array) $instance, $defaults );
		?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'image' ) ); ?>"><?php esc_html_e( 'Image', 'hillter' ); ?>:</label>
            <input type="text" class="widefat" style="width: 216px;" id="<?php echo esc_attr( $this->get_field_id( 'image' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'image' ) ); ?>" value="<?php echo esc_attr( $instance['image'] ); ?>" />
        </p>
        <label for="<?php esc_attr( $this->get_field_id( 'text' ) ); ?>">Content</label>
        <textarea class="widefat" id="<?php print $this->get_field_id( 'text' ); ?>" name="<?php print $this->get_field_name( 'text' ); ?>" type="text"></textarea>
        <?php
	}

}

/**
 * Awe : Facebook Page
 */
class AWE_Facebook_Page extends WP_Widget {

	public function __construct() {
		$widget_ops = array( 'classname' => 'widget_facebook', 'description' => __( 'Show Facebook fanpage', 'hillter' ) );
		parent::__construct( 'AWE_Facebook_Page', __( 'Awe : Facebook Page', 'hillter' ), $widget_ops );
	}

	public function widget($args, $instance) {
		extract( $args );

		$title = apply_filters( 'widget_title', $instance['title'] );
		$page_url = isset($instance['page_url']) ? $instance['page_url'] : "";
		$width = isset($instance['width']) ? $instance['width'] : "";
		$height = isset($instance['height']) ? $instance['height'] : "";
		$use_small_header = isset( $instance['use_small_header'] ) ? 'true' : 'false';
		$show_faces = isset( $instance['show_faces'] ) ? 'true' : 'false';
		$show_stream = isset( $instance['show_stream'] ) ? 'true' : 'false';
		$hide_cover = isset( $instance['hide_cover'] ) ? 'true' : 'false';
		$adapt_width = isset( $instance['adapt_width'] ) ? 'true' : 'false';
		print $before_widget;
		if ( $title ) {
			print $before_title . $title . $after_title;
		}

		if ( $page_url ) :
			?>
            <div id="fb-root"></div>
            <script>(function (d, s, id) {
                    var js, fjs = d.getElementsByTagName(s)[0];
                    if (d.getElementById(id))
                        return;
                    js = d.createElement(s);
                    js.id = id;
                    js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.3&appId=1510075135913200";
                    fjs.parentNode.insertBefore(js, fjs);
                }(document, 'script', 'facebook-jssdk'));</script>
            <?php
			$width = ($width) ? 'data-width="' . $width . 'px"' : '';
			$height = ($height) ? 'data-height="' . $height . 'px"' : '';
			echo '<div class="fb-page" data-href="' . $page_url . '" ' . $width . ' ' . $height . ' data-small-header="' . $use_small_header . '" data-adapt-container-width="' . $adapt_width . '" data-hide-cover="' . $hide_cover . '" data-show-facepile="' . $show_faces . '" data-show-posts="' . $show_stream . '"><div class="fb-xfbml-parse-ignore"><blockquote cite="' . $page_url . '"><a href="' . $page_url . '">' . $title . '</a></blockquote></div></div>';
		endif;
		print $after_widget;
	}

	public function form($instance) {
		$defaults = array( 'title' => __( 'Find us on Facebook', 'hillter' ), 'page_url' => '', 'width' => '292', 'color_scheme' => 'light', 'show_faces' => 'on', 'show_stream' => false, 'show_header' => false );
		$instance = wp_parse_args( (array) $instance, $defaults );
		?>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'hillter' ); ?>:</label>
            <input type="text" class="widefat" style="width: 216px;" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( isset( $instance['title'] ) ? $instance['title'] : '' ); ?>" />
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'page_url' ) ); ?>"><?php esc_html_e( 'Facebook Page URL', 'hillter' ); ?>:</label>
            <input type="text" class="widefat" style="width: 216px;" id="<?php echo esc_attr( $this->get_field_id( 'page_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'page_url' ) ); ?>" value="<?php echo esc_attr( isset( $instance['page_url'] ) ? $instance['page_url'] : '' ); ?>" />
        </p>



        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'width' ) ); ?>"><?php esc_html_e( 'Width', 'hillter' ); ?>:</label>
            <input type="text" class="widefat" style="width: 40px;" id="<?php echo esc_attr( $this->get_field_id( 'width' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'width' ) ); ?>" value="<?php echo esc_attr( isset( $instance['width'] ) ? $instance['width'] : 0 ); ?>" />
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'height' ) ); ?>"><?php esc_html_e( 'Height', 'hillter' ); ?>:</label>
            <input type="text" class="widefat" style="width: 40px;" id="<?php echo esc_attr( $this->get_field_id( 'height' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'height' ) ); ?>" value="<?php echo esc_attr( isset( $instance['height'] ) ? $instance['height'] : 0 ); ?>" />
        </p>

        <p>
            <input class="checkbox" type="checkbox" <?php checked( isset( $instance['use_small_header'] ) ? $instance['use_small_header'] : '', 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'use_small_header' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'use_small_header' ) ); ?>" />
            <label for="<?php echo esc_attr( $this->get_field_id( 'use_small_header' ) ); ?>"><?php esc_html_e( 'Use Small Header', 'hillter' ); ?></label>
        </p>

        <p>
            <input class="checkbox" type="checkbox" <?php checked( isset( $instance['show_faces'] ) ? $instance['show_faces'] : '', 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_faces' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_faces' ) ); ?>" />
            <label for="<?php echo esc_attr( $this->get_field_id( 'show_faces' ) ); ?>"><?php esc_html_e( "Show Friend's Faces", 'hillter' ); ?></label>
        </p>

        <p>
            <input class="checkbox" type="checkbox" <?php checked( isset( $instance['show_stream'] ) ? $instance['show_stream'] : '', 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_stream' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_stream' ) ); ?>" />
            <label for="<?php echo esc_attr( $this->get_field_id( 'show_stream' ) ); ?>"><?php esc_html_e( 'Show Page Posts', 'hillter' ); ?></label>
        </p>

        <p>
            <input class="checkbox" type="checkbox" <?php checked( isset( $instance['hide_cover'] ) ? $instance['hide_cover'] : '', 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'hide_cover' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'hide_cover' ) ); ?>" />
            <label for="<?php echo esc_attr( $this->get_field_id( 'hide_cover' ) ); ?>"><?php esc_html_e( 'Hide Cover Photo', 'hillter' ); ?></label>
        </p>

        <p>
            <input class="checkbox" type="checkbox" <?php checked( isset( $instance['adapt_width'] ) ? $instance['adapt_width'] : '', 'on' ); ?> id="<?php echo esc_attr( $this->get_field_id( 'adapt_width' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'adapt_width' ) ); ?>" />
            <label for="<?php echo esc_attr( $this->get_field_id( 'adapt_width' ) ); ?>"><?php esc_html_e( 'Adapt to plugin container width', 'hillter' ); ?></label>
        </p>
        <?php
	}

	public function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['page_url'] = $new_instance['page_url'];
		$instance['width'] = $new_instance['width'];
		$instance['height'] = $new_instance['height'];
		$instance['use_small_header'] = $new_instance['use_small_header'];
		$instance['show_faces'] = $new_instance['show_faces'];
		$instance['show_stream'] = $new_instance['show_stream'];
		$instance['hide_cover'] = $new_instance['hide_cover'];
		$instance['adapt_width'] = $new_instance['adapt_width'];
		return $instance;
	}

}

//Follow Us
class AWE_Follow_Us extends WP_Widget {

	protected $fields;

	public function __construct() {
		$widget_ops = array(
			'classname' => 'widget_social',
			'description'   => __( 'Display follow us information', 'hillter' ),
		);
		parent::__construct( 'widget-follow-us', __( 'Awe : Follow', 'hillter' ), $widget_ops );
		$this->fields = array(
			'title' => '',
			'facebook' => '',
			'google-plus' => '',
			'twitter' => '',
			'github' => '',
			'instagram' => '',
			'pinterest' => '',
			'linkedin' => '',
			'skype' => '',
			'tumblr' => '',
			'youtube-play' => '',
			'vimeo-square' => '',
			'flickr' => '',
			'dribbble' => '',
		);
	}

	public function widget($args, $instance) {
		$instance = wp_parse_args( (array) $instance, $this->fields );
		$title = strip_tags( $instance['title'] );
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		print $args['before_widget'];
		if ( $title ) { print $args['before_title'] . $title . $args['after_title']; }

			echo '<div class="widget-social">';
		foreach ( $this->fields as $k => $v ) {
			if ( $k == 'title' ) { continue; }
			if ( ! empty( $instance[$k] ) ) {
				echo '<a href="' . esc_url( $instance[$k] ) . '"><i class="fa fa-' . strip_tags( $k ) . '"></i></a>'; }
		}
			echo '</div>';

		print $args['after_widget'];
	}

	public function update($new_instance, $old_instance) {
		$instance = $old_instance;

		$instance['title'] = strip_tags( $new_instance['title'] );

		foreach ( $this->fields as $k => $v ) {
			if ( $k == 'title' ) { continue; }
			$instance[$k] = esc_url( $new_instance[$k] );
		}

		return $instance;
	}

	public function form($instance) {
		$instance = wp_parse_args( (array) $instance, $this->fields );
		$title = strip_tags( $instance['title'] );

		?>
            <?php
			foreach ( $this->fields as $k => $v ) :
				switch ( $k ) {
					case 'google-plus':
						$label = 'Google';
					break;

					case 'vimeo-square':
						$label = 'Vimeo';
					break;

					case 'youtube-play':
						$label = 'Youtube';
					break;

					default:
						$label = ucfirst( $k );
				}
				if ( $k == 'title' ) {
					$value = strip_tags( isset( $instance[$k] ) ? $instance[$k] : '' );
				} else {
				 	$value = esc_url( isset( $instance[$k] ) ? $instance[$k] : '' );
				}
			?>
                <p>
                    <label for="<?php print $this->get_field_id( $k ); ?>"><?php echo strip_tags( $label ); ?></label>
                    <input class="widefat" id="<?php print $this->get_field_id( $k ); ?>" name="<?php print $this->get_field_name( $k ); ?>" type="text" value="<?php print $value; ?>" />
                </p>
            <?php endforeach; ?>

        <?php

	}

}

class Awe_follow_us_widget extends WP_Widget {

	protected $socials;

	function __construct() {
		$widget_ops = array( 'classname' => 'widget_followus', 'description' => __( 'Show follow content inside footer', 'hillter' ) );
		parent::__construct( 'Awe_follow_us_widget', __( 'Awe : Follow Us', 'hillter' ), $widget_ops );
		$this->socials = array(
			'facebook' => 'fa fa-facebook',
			'google' => 'fa fa-google-plus',
			'twitter' => 'fa fa-twitter-square',
			'github' => 'fa fa-github-square',
			'instagram' => 'fa fa-instagram',
			'pinterest' => 'fa fa-pinterest',
			'linkedin' => 'fa fa-linkedin-square',
			'skype' => 'fa fa-skype',
			'tumblr' => 'fa fa-tumblr',
			'youtube' => 'fa fa-youtube',
			'vimeo' => 'fa fa-vimeo-square',
			'flickr' => 'fa fa-flickr',
			'dribbble' => 'fa fa-dribbble',
		);
	}

	public function widget($args, $instance) {
		extract( $args );
		$title = isset( $instance['title'] ) ? $instance['title'] : 'Follow Us';
		$position = isset( $instance['social_position'] ) ? $instance['social_position'] : 'normal';
		global $hillter_option, $socials, $stt, $val;
		$html = '';
		$html .= ($position == 'footer') ? '<div class="col-md-5 col-lg-3 col-lg-offset-1">' : '';
		$html .= '<aside class="widget widget_social">';
		$html .= ($position == 'footer') ? '' : '<h4 class="text-uppercase widget-title"><span>' . $title . '</span></h4>';
		$html .= ($position == 'footer') ? '<div class="social"><div class="social-content">' : '<div class="widget-social">';
		$a = 1;
		foreach ( $this->socials as $k => $v ) {
			$stt = $hillter_option['social'][$k]['enable'];
			$val = $hillter_option['social'][$k]['url'];
			if ( $stt == 1 ) {
				$html .= '<a target="_blank" class="_' . esc_attr( $a ) . '" href="' . esc_url( $val ) . '"><i class="' . esc_attr( $v ) . '"></i></a>';
			}
			$a++;
		}
		$html .= ('footer' == $position ) ? '</div></div>' : '</div>';
		$html .= '</aside>';
		$html .= ('footer' == $position ) ? '</div>' : '';
		print ($html);
	}

	public function form($instance) {
		$instance = wp_parse_args( $instance, array( 'title' => 'Follow us' ) );
		?>
        <p>
            <label for="<?php print ($this->get_field_id( 'title' )); ?>">Title</label>
            <input type="text" class="widefat" name="<?php print ($this->get_field_name( 'title' )); ?>"
                   id="<?php print ($this->get_field_id( 'title' )); ?>" value="<?php echo esc_attr( $instance['title'] ) ?>"/>
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'social_position' ) ); ?>"><?php esc_html_e( 'Position', 'hillter' ); ?>:</label>
            <?php $position = isset( $instance['social_position'] ) ? $instance['social_position'] : 'normal';
				?>
            <select id="<?php echo esc_attr( $this->get_field_id( 'social_position' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'social_position' ) ); ?>" style="width:100%;">
                <option <?php if ( 'normal' == $position ) { echo 'selected="selected"'; } ?> value="normal"><?php esc_html_e( 'Normal', 'hillter' ); ?></option>
                <option <?php if ( 'footer' == $position ) { echo 'selected="selected"'; } ?> value="footer"><?php esc_html_e( 'Footer', 'hillter' ); ?></option>
            </select>
        </p>
        <?php
	}

	public function update($new_instance, $old_instance) {
		$instance = $old_instance;
		foreach ( $new_instance as $key => $value ) {
			$instance[$key] = strip_tags( $value );
		}
		return $instance;
	}

}

//Mailchimp

class Awe_Mailchimp_widget extends WP_Widget {

	function __construct() {
		$widget_ops = array( 'classname' => 'widget_mailchimp', 'description' => __( 'Awe Newletter', 'hillter' ) );
		parent::__construct( 'Awe_Mailchimp_widget', __( 'Awe : Newletter', 'hillter' ), $widget_ops );
	}

	function widget($args, $instance) {
		extract( $args );
		$title = empty( $instance['title'] ) ? '' : apply_filters( 'widget_title', $instance['title'] );
		print ($before_widget);
		$output = '<div class="col-md-7 col-lg-8">';
		$output .= '<div class="letter-from mailchimp" id="mailchimp-box">';
		$output .= '<h4>' . $title . '</h4>';
		$output .= '<div class="mailchimp-form">';
		$output .= '<input id="subscribeNonce" type="hidden" name="_wpnonce" value="' . wp_create_nonce( 'subscribe-Nonce' ) . '" />';
		$output .= '<form name="MailChimpForm" action="' . esc_url( home_url( '/' ) ) . '" method="POST">';
		$output .= '<input type="text" name="email" placeholder="Enter Email..." class="input-text" value="" id="emailtext">';
		$output .= '<button class="awe-btn">' . __( 'SIGN UP', 'hillter' ) . '</button>';
		$output .= '</form>';
		$output .= '</div>';
		$output .= '</div>';
		$output .= '<div id="error_box"></div>';
		$output .= '</div>';
		print ($output);
		?>

        <?php
		print ($after_widget);
	}

	function form($instance) {
		$instance = wp_parse_args( $instance, array( 'title' => 'Mailchimp', 'action' => '' ) );
		?>
        <p>
            <label for="<?php print esc_attr( $this->get_field_id( 'title' ) ); ?>">Title</label>
            <input type="text" class="widefat" name="<?php print esc_attr( $this->get_field_name( 'title' ) ); ?>"
                   id="<?php print esc_attr( $this->get_field_id( 'title' ) ); ?>" value="<?php echo esc_attr( $instance['title'] ) ?>"/>
        </p>
        <?php
	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		foreach ( $new_instance as $key => $value ) {
			$instance[$key] = strip_tags( $value );
		}
		return $instance;
	}

}

//Flickr

class Awe_Flickr_widget extends WP_Widget {
	protected static $did_script = false;
	function __construct() {
		$widget_ops = array( 'classname' => 'widget_flickr', 'description' => __( 'Display your latest Flickr Photos.', 'hillter' ) );
		parent::__construct( 'Awe_Flickr_widget', __( 'Awe : Flickr', 'hillter' ), $widget_ops );
		add_action( 'wp_enqueue_scripts', array( $this, 'awe_flickr_script' ) );
	}

	public function awe_flickr_script() {
		$url = get_template_directory_uri();
		//Register script when widget appended
		if ( ! self::$did_script && is_active_widget( false, false, $this->id_base, true ) ) {
			wp_register_script( 'awe-jquery-flickrfeed', $url . '/assets/js/lib/jflickrfeed.min.js', array( 'jquery' ) );
			wp_enqueue_script( 'awe-jquery-flickrfeed' );
			self::$did_script = true;
		}
	}

	function widget($args, $instance) {
		extract( $args, EXTR_SKIP );
		$widget_id = $this->id;
		$title = isset( $instance['title'] ) ? apply_filters( 'widget-title', $instance['title'] ) : '';
		$id = isset( $instance['id'] ) ? strip_tags( $instance['id'] ) : '';
		$limit = isset( $instance['limit'] ) ? strip_tags( $instance['limit'] ) : 8;
		$output = '';
		$output .= $before_widget;
		if ( ! empty( $title ) ) {
			$output .= $before_title . $title . $after_title; }
		$output .= "<div id='" . $widget_id . "-content' class='flickr clearfix'>";
		$output .= '</div>';
		$output .= '<script type="text/javascript">';
		$output .= 'jQuery(document).ready(function($){';
		$output .= '$("#' . $widget_id . '-content").jflickrfeed({';
		$output .= 'limit: ' . $limit . ',';
		$output .= 'qstrings: {';
		$output .= "id: '" . $id . "',";
		$output .= '},';
		$output .= 'itemTemplate: \'<a href="{{link}}" title="{{title}}"><img alt="{{title}}" src="{{image_s}}" /></a>\'';
		$output .= '})';
		$output .= '})';
		$output .= '</script>';
		$output .= $after_widget;

		print ($output);
	}

	public function form($instance) {
		$instance = wp_parse_args( $instance, array( 'title' => 'Flickr', 'id' => '', 'limit' => 6 ) );
		?>
        <p>
            <label for="<?php print ($this->get_field_id( 'title' )) ?>"><?php esc_html_e( 'Title', 'hillter' ) ?></label>
            <input type="text" name="<?php print ($this->get_field_name( 'title' )) ?>"
                   id="<?php print ($this->get_field_id( 'title' )) ?>" class="widefat"
                   value="<?php echo esc_attr( isset( $instance['title'] ) ? $instance['title'] : '' ) ?>">
        </p>
        <p>
            <label for="<?php print ($this->get_field_id( 'id' )); ?>"><?php esc_html_e( 'Id', 'hillter' ) ?></label>
            <input type="text" name="<?php print ($this->get_field_name( 'id' )); ?>"
                   id="<?php print ($this->get_field_id( 'id' )); ?>" class="widefat"
                   value="<?php echo esc_attr( isset( $instance['id'] ) ? $instance['id'] : '' ) ?>"
                   placeholder="<?php esc_html_e( 'required', 'hillter' ) ?>">
            <span><a href="<?php echo 'http://idgettr.com/'; ?>" target="_blank">Find the Flickr Id number</a></span>
        </p>
        <p>
            <label for="<?php print ($this->get_field_id( 'limit' )); ?>"><?php esc_html_e( 'Limit', 'hillter' ) ?></label>
            <input type="text" name="<?php print ($this->get_field_name( 'limit' )); ?>"
                   id="<?php print ($this->get_field_id( 'limit' )); ?>" class="widefat"
                   value="<?php echo esc_attr( isset( $instance['limit'] ) ? $instance['limit'] : 8 ) ?>">
        </p>
        <?php
	}

	public function update($newInstance, $oldInstance) {
		$instance = $oldInstance;

		foreach ( $newInstance as $k => $v ) {
			if ( 'limit' == $k ) {
				$instance[$k] = (int) $v;
			} else {
				$instance[$k] = strip_tags( $v );
			}
		}

		return $instance;
	}

}

//Instagram
class Awe_instagram_widget extends WP_Widget {

	function __construct() {
		$widget_ops = array( 'classname' => 'widget_instagram widget_flickr', 'description' => __( 'Displays your latest Instagram photos.', 'hillter' ) );
		parent::__construct( 'awe_instagram_widget', __( 'Awe : Instagram', 'hillter' ), $widget_ops );
	}

	function widget($args, $instance) {
		extract( $args, EXTR_SKIP );
		$title = empty( $instance['title'] ) ? '' : apply_filters( 'widget_title', $instance['title'] );
		$username = empty( $instance['username'] ) ? '' : $instance['username'];
		$limit = empty( $instance['number'] ) ? 9 : $instance['number'];
		$target = empty( $instance['target'] ) ? '_self' : $instance['target'];
		$link = empty( $instance['link'] ) ? '' : $instance['link'];
		print ($before_widget);
		if ( ! empty( $title ) ) {
			print ($before_title . $title . $after_title);
		};
		if ( $username != '' ) {
			$media_array = $this->scrape_instagram( $username, $limit );
			if ( is_wp_error( $media_array ) ) {
				print ($media_array->get_error_message());
			} else {
				// filter for images only?
				if ( $images_only = apply_filters( 'wpiw_images_only', false ) ) {
				}
					?><div class="instagram flickr"><?php
foreach ( $media_array as $item ) {
	echo '<a href="' . esc_url( $item['link'] ) . '" target="' . esc_attr( $target ) . '"><img src="' . esc_url( $item['display_src'] ) . '" alt="' . esc_attr( $item['description'] ) . '" title="' . esc_attr( $item['description'] ) . '"/></a>';
}
				?></div><?php
			}
		}
		if ( $link != '' ) {
			?><p class="clear"><a href="//instagram.com/<?php echo trim( $username ); ?>" rel="me" target="<?php echo esc_attr( $target ); ?>"><?php echo esc_attr( $link ); ?></a></p><?php
		}
			print ($after_widget);
	}

	function form($instance) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => __( 'Instagram', 'hillter' ), 'username' => '', 'link' => __( 'Follow Us', 'hillter' ), 'number' => 9, 'size' => 'thumbnail', 'target' => '_self' ) );
		$title = esc_attr( $instance['title'] );
		$username = esc_attr( $instance['username'] );
		$number = absint( $instance['number'] );
		$target = esc_attr( $instance['target'] );
		$link = esc_attr( $instance['link'] );
		?>
        <p><label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'hillter' ); ?>: <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" /></label></p>
        <p><label for="<?php echo esc_attr( $this->get_field_id( 'username' ) ); ?>"><?php esc_html_e( 'Username', 'hillter' ); ?>: <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'username' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'username' ) ); ?>" type="text" value="<?php echo esc_attr( $username ); ?>" /></label></p>
        <p><label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of photos', 'hillter' ); ?>: <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" /></label></p>
        <p><label for="<?php echo esc_attr( $this->get_field_id( 'target' ) ); ?>"><?php esc_html_e( 'Open links in', 'hillter' ); ?>:</label>
            <select id="<?php echo esc_attr( $this->get_field_id( 'target' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'target' ) ); ?>" class="widefat">
			<option value="_self" <?php selected( '_self', $target ) ?>><?php esc_html_e( 'Current window (_self)', 'hillter' ); ?></option>
			<option value="_blank" <?php selected( '_blank', $target ) ?>><?php esc_html_e( 'New window (_blank)', 'hillter' ); ?></option>
            </select>
        </p>
        <p><label for="<?php echo esc_attr( $this->get_field_id( 'link' ) ); ?>"><?php esc_html_e( 'Link text', 'hillter' ); ?>: <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'link' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'link' ) ); ?>" type="text" value="<?php echo esc_attr( $link ); ?>" /></label></p>
        <?php
	}

	function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['username'] = trim( strip_tags( $new_instance['username'] ) );
		$instance['number'] = ! absint( $new_instance['number'] ) ? 9 : $new_instance['number'];
		$instance['target'] = (($new_instance['target'] == '_self' || $new_instance['target'] == '_blank') ? $new_instance['target'] : '_self');
		$instance['link'] = strip_tags( $new_instance['link'] );
		return $instance;
	}

	// based on https://gist.github.com/cosmocatalano/4544576
	function scrape_instagram($username, $slice = 9) {
		$username = strtolower( $username );
		$instagram = array();
		if ( $username ) {
			// if (false != get_transient('instagram-media-' . sanitize_title_with_dashes($username))) {
			$remote = wp_remote_get( 'http://instagram.com/' . trim( $username ) );

			if ( is_wp_error( $remote ) ) {
				return new WP_Error( 'site_down', __( 'Unable to communicate with Instagram.', 'hillter' ) ); }
			if ( 200 != wp_remote_retrieve_response_code( $remote ) ) {
				return new WP_Error( 'invalid_response', __( 'Instagram did not return a 200.', 'hillter' ) ); }
			$shards = explode( 'window._sharedData = ', $remote['body'] );
			$insta_json = explode( ';</script>', $shards[1] );
			$insta_array = json_decode( $insta_json[0], true );
			if ( ! $insta_array ) {
				return new WP_Error( 'bad_json', __( 'Instagram has returned invalid data.', 'hillter' ) ); }
			// Instagram API
			$images = $insta_array['entry_data']['ProfilePage'][0]['user']['media']['nodes'];
			foreach ( $images as $image ) {
				$link = isset( $image['code'] ) ? 'https://instagram.com/p/'.$image['code'].'/?taken-by='.$username : '#'; // Generate Instagame Photo Link
					$instagram[] = array(
						'description' => isset( $image['caption'] ) ? $image['caption'] : '',
						'link' => $link,
						'comments' => $image['comments']['count'],
						'likes' => $image['likes']['count'],
						'display_src' => $image['display_src'],
						'is_video' => $image['is_video'],
					);
			}

			set_transient( 'instagram-media-' . sanitize_title_with_dashes( $username ), $instagram, apply_filters( 'null_instagram_cache_time', HOUR_IN_SECONDS * 2 ) );
		}
		return array_slice( $instagram, 0, $slice );
	}

	function images_only($media_item) {
		if ( $media_item['type'] == 'image' ) {
			return true; }
		return false;
	}

}

// Recent Comments
class Awe_Widget_Recent_Comments extends WP_Widget {

	public function __construct() {
		$widget_ops = array( 'classname' => 'widget_latest_comments', 'description' => __( 'Your site&#8217;s most recent comments.', 'hillter' ) );
		parent::__construct( 'awe-recent-comments', __( 'Awe : Recent Comments', 'hillter' ), $widget_ops );
		$this->alt_option_name = 'widget_recent_comments';

		if ( is_active_widget( false, false, $this->id_base ) ) {
			add_action( 'wp_head', array( $this, 'recent_comments_style' ) ); }

		add_action( 'comment_post', array( $this, 'flush_widget_cache' ) );
		add_action( 'edit_comment', array( $this, 'flush_widget_cache' ) );
		add_action( 'transition_comment_status', array( $this, 'flush_widget_cache' ) );
	}

	public function recent_comments_style() {

		/**
		 * Filter the Recent Comments default widget styles.
		 *
		 * @since 3.1.0
		 *
		 * @param bool   $active  Whether the widget is active. Default true.
		 * @param string $id_base The widget ID.
		 */
		if ( ! current_theme_supports( 'widgets' ) // Temp hack #14876
				|| ! apply_filters( 'show_recent_comments_widget_style', true, $this->id_base ) ) {
			return; }
		?>
        <style type="text/css">.recentcomments a{display:inline !important;padding:0 !important;margin:0 !important;}</style>
        <?php
	}

	public function flush_widget_cache() {
		wp_cache_delete( 'widget_recent_comments', 'widget' );
	}

	public function widget($args, $instance) {
		global $comments, $comment;

		$cache = array();
		if ( ! $this->is_preview() ) {
			$cache = wp_cache_get( 'widget_recent_comments', 'widget' );
		}
		if ( ! is_array( $cache ) ) {
			$cache = array();
		}

		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id; }

		if ( isset( $cache[$args['widget_id']] ) ) {
			echo '' . $cache[$args['widget_id']];
			return;
		}

		$output = '';

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Recent Comments', 'hillter' );

		/** This filter is documented in wp-includes/default-widgets.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
		if ( ! $number ) {
			$number = 5; }

		/**
		 * Filter the arguments for the Recent Comments widget.
		 *
		 * @since 3.4.0
		 *
		 * @see WP_Comment_Query::query() for information on accepted arguments.
		 *
		 * @param array $comment_args An array of arguments used to retrieve the recent comments.
		 */
		$comments = get_comments(apply_filters('widget_comments_args', array(
			'number' => $number,
			'status' => 'approve',
			'post_status' => 'publish',
		)));

		$output .= $args['before_widget'];
		if ( $title ) {
			$output .= $args['before_title'] . $title . $args['after_title'];
		}

		$output .= '<ul id="recentcomments">';
		if ( $comments ) {
			// Prime cache for associated posts. (Prime post term cache if we need it for permalinks.)
			$post_ids = array_unique( wp_list_pluck( $comments, 'comment_post_ID' ) );
			_prime_post_caches( $post_ids, strpos( get_option( 'permalink_structure' ), '%category%' ), false );

			foreach ( (array) $comments as $comment ) {
				$output .= '<li class="recentcomments">';
				$output .= '<div class="image-wrap">';
				$output .= get_avatar( $comment->comment_author_email, 80 );
				$output .= '</div>';
				$output .= '<div class="comment-info">';
				$output .= '<span class="author">' . get_comment_author_link() . '</span>';
				$output .= '<a href="' . esc_url( get_comment_link( $comment->comment_ID ) ) . '">' . apply_filters( 'awe_truncate_content', get_comment_text(), 50 ) . '</a>';
				$output .= '<div class="meta">';
				$output .= '<span>' . get_comment_time( 'M j,Y ' ) . '</span>';
				$output .= '</div>';
				$output .= '</div>';
				$output .= '</li>';
			}
		}
		$output .= '</ul>';
		$output .= $args['after_widget'];

		echo '' . $output;

		if ( ! $this->is_preview() ) {
			$cache[$args['widget_id']] = $output;
			wp_cache_set( 'widget_recent_comments', $cache, 'widget' );
		}
	}

	public function update($new_instance, $old_instance) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['number'] = absint( $new_instance['number'] );
		$this->flush_widget_cache();

		$alloptions = wp_cache_get( 'alloptions', 'options' );
		if ( isset( $alloptions['widget_recent_comments'] ) ) {
			delete_option( 'widget_recent_comments' ); }

		return $instance;
	}

	public function form($instance) {
		$title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$number = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
		?>
        <p><label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'hillter' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" /></p>

        <p><label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of comments to show:', 'hillter' ); ?></label>
            <input id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" size="3" /></p>
        <?php
	}

}

class Awe_slide_image extends WP_Widget {

	function __construct() {

		parent::__construct( 'Awe_slide_image', __( 'Awe : Image Slider', 'hillter' ) );

		add_action( 'load-widgets.php', array( $this, 'enqueue_script' ) );
	}

	function enqueue_script() {
		wp_enqueue_script( 'awe-media-gallery', AWE_JS_URL . 'gallery_w.js', array( 'jquery' ), null, false );
	}

	function form($instance) {
		//parent::form($instance);
		$title = isset( $instance['title'] ) ? $instance['title'] : __( 'Slider', 'hillter' );
		?>
        <style>
            .awe_gallery_images li img {  max-height: 150px;  max-width: 150px; }
            .awe_gallery_images .image{  display: inline-block;   position: relative; padding-bottom: 16px;  border-bottom: 1px solid;}
            .actions {   bottom: -5px;  display: inline-block;   position: absolute;    right: 30px;  }
            .actions a {  text-decoration: none;  color: black;   font-weight: bold; }
            .delete{cursor: pointer}
            .btn.awe_add_gallery{margin-bottom: 10px;padding:3px;}

        </style>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">Title:</label>
            <input type="text" value="<?php echo esc_attr( $title ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" class="widefat">
        </p>
        <ul class="awe_gallery_images" id="<?php echo esc_attr( $this->get_field_id( 'awe_slide' ) ); ?>">
            <?php
			if ( ! empty( $instance['awe_galerry'] ) ) :
				$img_id = explode( ',', $instance['awe_galerry'] );
				foreach ( $img_id as $id ) :
					if ( $id != '' ) :
						$image = wp_get_attachment_image_src( $id, 'thumbnail' );
						?>
                        <li data-id="<?php echo esc_html( $id ) ?>" class="image id-<?php echo esc_attr( $this->get_field_id( 'awe_slide' ) ); ?>">
                            <img src="<?php echo esc_url( str_replace( '-150x150', '', $image[0] ) ) ?>">
                            <ul class="actions">
                                <li><a href="#" title="delete" data-id="<?php echo ($this->get_field_id( 'awe_slide' )) ?>" class="delete_fix"><?php esc_html_e( 'delete', 'hillter' ) ?></a></li>
                            </ul>
                        </li>
                        <?php
					endif;
				endforeach;
			endif;
			?>
        </ul>
        <button type='button' class='btn awe_add_gallery_fix' data-id="<?php echo esc_attr( $this->get_field_id( 'awe_slide' ) ) ?>" ><?php esc_html_e( 'Add Images', 'hillter' ) ?></button>
        <input type="hidden" name="<?php echo esc_attr( $this->get_field_name( 'awe_galerry' ) ); ?>" class="gallery-widget-val val-gallery-<?php echo esc_attr( $this->get_field_id( 'awe_slide' ) ) ?>" value="<?php echo isset( $instance['awe_galerry'] ) ? esc_attr( $instance['awe_galerry'] ) : ''; ?>">
        <?php
	}

	function update($new_instance, $old_instance) {
		parent::update( $new_instance, $old_instance );
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['awe_galerry'] = strip_tags( $new_instance['awe_galerry'] );
		return $instance;
	}

	function widget($args, $instance) {
		?>
        <!-- WIDGET PHOTO SLIDE -->
        <div class="widget widget_awe_photo_slide">
            <?php if ( isset( $instance['title'] ) && $instance['title'] != '' ) : ?>
                <h4 class="widget-title"><span><?php echo esc_html( $instance['title'] ); ?></span></h4>
            <?php endif; ?>
           <div class="widget-awe-photo-slide owl-single">
                    <?php
					$img_id = explode( ',', $instance['awe_galerry'] );
					if ( count( $img_id ) > 0 ) {
						foreach ( $img_id as $id ) {
							if ( $id != '' ) {
								$image = wp_get_attachment_image_src( $id, 'full' );
								if ( $image != false ) :
									?>
									<!-- ITEM -->
                                        <div class="item">
                                            <div class="img">
                                                <img src="<?php echo esc_url( $image[0] ) ?>" alt="">
                                            </div>
                                        </div>
                                    <!-- END / ITEM -->
                                <?php
								endif;
							}
						}
					}
					?>
                </div>
        </div>
        <!-- END WIDGET PHOTO SLIDE -->
        <?php
	}

}

class awe_recent_posts_widget extends WP_Widget {

	public function __construct() {
		parent::__construct(
			'awe_recent_posts_widget', __( 'Awe : Recent Post', 'LANGUAGE' ), array( 'classname' => 'awe-widget_recent_entries', 'description' => __( 'Display the lastest posts', 'hillter' ) )
		);
	}

	public function form($instance) {
		$defaults = array(
			'title'	=> __( 'Latest Posts', 'hillter' ),
			'cat'	=> 0,
			'qty' => 5,
			'disable_thumb'	=> 0,
		);
		$instance = wp_parse_args( (array) $instance, $defaults );
		$title = strip_tags( $instance['title'] );
		$qty = absint( $instance['qty'] );
		$cat = absint( $instance['cat'] );
		$disable_thumb = $instance['disable_thumb'] == 1 ? 1 : 0;
		$list_cats = get_categories( 'hide_empty=0' );
		?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'hillter' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>

        <p>
            <label for="<?php print $this->get_field_id( 'cat' ); ?>"><?php _e( 'Category', 'hillter' ); ?></label>
            <select class="widefat" id="<?php print $this->get_field_id( 'cat' ); ?>" name="<?php print $this->get_field_name( 'cat' ) ?>">
                <option value="0" <?php selected( $cat, 0 ); ?>><?php _e( 'All categories', 'hillter' ); ?></option>
                <?php foreach ( $list_cats as $v ) : ?>
                    <option value="<?php echo absint( $v->term_id ); ?>" <?php selected( $cat, $v->term_id ); ?>><?php echo strip_tags( $v->cat_name ); ?></option>
                <?php endforeach; ?>
            </select>
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'qty' ) ); ?>"><?php esc_html_e( 'Number of Posts to show', 'hillter' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'qty' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'qty' ) ); ?>" type="number" min="1" step="1" value="<?php echo esc_attr( $qty ); ?>" />
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'disable_thumb' ) ); ?>"><?php esc_html_e( 'Disable Thumbnail', 'hillter' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'disable_thumb' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'disable_thumb' ) ); ?>" type="checkbox" <?php checked( 1, $disable_thumb ); ?> value="1" />
        </p>

        <?php
	}

	public function update($new_instance, $old_instance) {
		$instance = array();
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['qty'] = absint( $new_instance['qty'] );
		$instance['cat'] = absint( $new_instance['cat'] );
		$instance['disable_thumb'] = $new_instance['disable_thumb'] == 1 ? 1 : 0;
		return $instance;
	}

	public function widget($args, $instance) {
		// extract( $args );
		$defaults = array(
			'title'	=> __( 'Latest Posts', 'hillter' ),
			'cat'	=> 0,
			'qty' => 5,
			'disable_thumb'	=> 0,
		);
		$instance = wp_parse_args( (array) $instance, $defaults );

		$title = strip_tags( $instance['title'] );
		$title = apply_filters( 'widget_title', $instance['title'] );

		$qty = absint( $instance['qty'] );
		$cat = absint( $instance['cat'] );
		$disable_thumb = $instance['disable_thumb'] == 1 ? 1 : 0;

		$query_args = array( 'posts_per_page' => $qty );
		if ( $cat ) {
			$query_args['cat'] = $cat;
		}
		$the_query = new WP_Query( $query_args );

		print $args['before_widget'];
		if ( $title ) { print $args['before_title'] . $title . $args['after_title']; }

		if ( $the_query->have_posts() ) :

			echo '<ul>';
			while ( $the_query->have_posts() ) : $the_query->the_post();
				?>
					<li>
						<?php if ( ! $disable_thumb && has_post_thumbnail() ) : ?>
	                            <div class="img">
	                                <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'thumbnail' ); ?></a>
	                            </div>
	                        <?php endif; ?>
						<div class="text">
							<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
							<span class="date"><?php printf( __( 'at %1$s', 'hillter' ), get_the_time( get_option( 'date_format' ) ) ); ?></span>
						</div>
					</li>
					<?php
				endwhile; wp_reset_postdata();
			echo '</ul>';

		endif;

		print $args['after_widget'];
	}

	public function get_cat_posts($title = '', $qty) {

		$title = ( ! empty( $title )) ? $title : '';
		echo '<aside class="widget widget_recent_entries has-thumbnail"><h4 class="text-uppercase widget-title"><span>' . esc_html( $title ) . '</span></h4>' . "\r\n";
		$posts = new WP_Query(
			'orderby=date&order=DESC&posts_per_page=' . $qty
		);
		echo '<ul>' . "\r\n";

		while ( $posts->have_posts() ) {
			$posts->the_post();
			?>
            <li>
                <div class="img">
                    <a href="<?php the_permalink(); ?>">
                        <?php the_post_thumbnail( 'awe-thumbnail-small', array( 'title' => '' ) ); ?>
                    </a>
                </div>
                <div class="text">
                    <a href="<?php the_permalink() ?>"><?php the_title(); ?></a>
                    <span class="date"><?php the_time( get_option( 'date_format' ) ); ?></span>
                </div>
            </li>
            <?php
		}
	    wp_reset_postdata();
		echo '</ul>' . "\r\n";
	}

}

class awe_recent_event_widget extends WP_Widget {

	public function __construct() {
		parent::__construct(
			'awe_recent_event_widget', __( 'Awe : Recent Event', 'LANGUAGE' ), array( 'description' => __( 'Display the latest event', 'hillter' ) )
		);
	}

	public function form($instance) {
		$defaults = array(
			'qty' => 10,
		);
		$instance = wp_parse_args( (array) $instance, $defaults );
		$title = isset( $instance['title'] ) ? $instance['title'] : __( 'Latest Posts', 'hillter' );
		$qty = isset( $instance['qty'] ) ? esc_attr( $instance['qty'] ) : 5;
		?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'hillter' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'qty' ) ); ?>"><?php esc_html_e( 'Number of Posts to show', 'hillter' ); ?></label>
            <input id="<?php echo esc_attr( $this->get_field_id( 'qty' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'qty' ) ); ?>" type="number" min="1" step="1" value="<?php echo esc_attr( $qty ); ?>" />
        </p>

        <?php
	}

	public function update($new_instance, $old_instance) {
		$instance = array();
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['qty'] = intval( $new_instance['qty'] );
		return $instance;
	}

	public function widget($args, $instance) {
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		$qty = (int) $instance['qty'];

		echo self::get_cat_posts( $title, $qty );
		print ($after_widget);
	}

	public function get_cat_posts($title = '', $qty) {

		$title = ( ! empty( $title )) ? $title : '';
		echo '<aside class="widget widget_upcoming_events"><h4 class="text-uppercase widget-title"><span>' . esc_html( $title ) . '</span></h4>' . "\r\n";
		$posts = new WP_Query(
			'post_type=event&orderby=date&order=DESC&posts_per_page=' . $qty
		);
		echo '<ul>' . "\r\n";

		while ( $posts->have_posts() ) {
			$posts->the_post();
			?>
            <li>
                <span class="event-date">
                    <strong><?php echo get_the_date( 'd' ); ?></strong>
                    <?php echo get_the_date( 'M' ); ?>
                </span>
                <div class="text">
                    <a href="<?php the_permalink() ?>"><?php the_title(); ?></a>
                    <span class="date"><?php the_time( get_option( 'date_format' ) ); ?></span>
                </div>
            </li>
            <?php
		}
	    wp_reset_postdata();
		echo '</ul>' . "\r\n";
	}
}
