<?php
/**
 *
 * @package Wordpress
 * @subpackage Hillter
 * @return 404 template
 */
get_header();
// Background Style
echo awe_404_bg();
$op = awe_404_op();
?>
	<!-- 404 PAGE -->
	<section class="section-404">
		<div class="awe-overlay"></div>
		<div class="page-404 text-center">
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo ! empty( $op['logo']) ? $op['logo'] : get_template_directory_uri().'/assets/images/default/logo-big.png'; ?>" alt=""></a>

			<?php echo ! empty( $op['title'] ) ? ( '<h1>' . $op['title'] . '</h1>' ) : ""; ?>
			<?php echo ! empty( $op['sub_title'] ) ? ( '<h6>' . $op['sub_title'] . '</h6>' ) : ""; ?>

			<?php echo ! empty( $op['desc'] ) ? ( '<p>' . $op['desc'] . '</p>' ) : ""; ?>

			<div class="search-404">
				<form action="<?php echo esc_url( home_url( '/' ) ); ?>" method="get">
					<input type="text" class="filed-text" placeholder="<?php esc_html_e( 'Search page', 'hillter' ); ?>" name="s">
					<button type="submit" class="awe-btn awe-btn-12"><?php esc_html_e( 'SEARCH', 'hillter' ); ?></button>
				</form>
			</div>

			<p><?php _e( 'or go back to', 'hillter' ); ?> <a href="<?php echo( ! empty( $op['link'] ) ? esc_url( $op['link'] ) : esc_url( home_url( '/' ) ) ); ?>"><?php echo( ! empty( $op['text'] ) ? $op['text'] : __( 'home', 'hillter' ) ); ?></a>
			</p>
		</div>

	</section>
	<!-- END / 404 PAGE-->
<?php
get_footer();
?>
