<?php
/**
 * Activate account page template
 *
 * @package Mailchimp
 */

?>
<div class="mailchimp-sf-confirm-email-wrapper mailchimp-sf-content-box-wrapper <?php echo esc_attr( ( ! $signup_initiated ) ? 'hidden' : '' ); ?>">
	<div class="mailchimp-sf-confirm-email mailchimp-sf-content-box">
		<div class="title"><?php esc_html_e( 'Check your email', 'mailchimp' ); ?></div>
		<p class="h4">
			<?php
			echo wp_kses(
				sprintf(
					/* translators: %s - email address */
					__( 'We\'ve sent a message to %s with a link to activate your account.', 'mailchimp' ),
					'<span class="mailchimp-sf-email">' . esc_html( $email ) . '</span>'
				),
				array(
					'span' => array(
						'class' => array(),
					),
				)
			);
			?>
		</p>

		<div class="flex items-center gap-x-6 email-opener-wrapper">
			<a href="https://mail.google.com/mail/u/0/" target="_blank" class="flex items-center gap-x-2">
				<svg width="33" height="25" viewBox="0 0 33 25" fill="none" xmlns="http://www.w3.org/2000/svg">
					<g clip-path="url(#clip0_6481_9704)">
						<path d="M2.25 24.8633H7.5V12.1133L0 6.48828V22.6133C0 23.8583 1.00875 24.8633 2.25 24.8633Z" fill="#4285F4"></path>
						<path d="M25.4999 24.8633H30.7499C31.9949 24.8633 32.9999 23.8545 32.9999 22.6133V6.48828L25.4999 12.1133" fill="#34A853"></path>
						<path d="M25.4999 2.36344V12.1134L32.9999 6.48844V3.48844C32.9999 0.705939 29.8236 -0.880311 27.5999 0.788438" fill="#FBBC04"></path>
						<path d="M7.50012 12.1133V2.36328L16.5001 9.11328L25.5001 2.36328V12.1133L16.5001 18.8633" fill="#EA4335"></path>
						<path d="M0 3.48844V6.48844L7.5 12.1134V2.36344L5.4 0.788438C3.1725 -0.880311 0 0.705939 0 3.48844Z" fill="#C5221F"></path>
					</g>
					<defs>
						<clipPath id="clip0_6481_9704">
							<rect width="33" height="24.75" fill="white" transform="translate(0 0.113403)"></rect>
						</clipPath>
					</defs>
				</svg>
				<span class="email-opener"><?php esc_html_e( 'Open Gmail', 'mailchimp' ); ?></span>
			</a>
			<a href="https://outlook.live.com/mail/0/inbox" target="_blank" class="flex items-center gap-x-2">
				<svg width="29" height="27" viewBox="0 0 29 27" fill="none" xmlns="http://www.w3.org/2000/svg">
					<g clip-path="url(#clip0_6481_9712)">
						<path d="M28.9995 14.1625C29.0011 13.9358 28.8839 13.7247 28.6906 13.6061H28.6872L28.6751 13.5994L18.6262 7.65103C18.5828 7.62172 18.5378 7.59492 18.4914 7.57078C18.1034 7.37061 17.6425 7.37061 17.2545 7.57078C17.208 7.59494 17.163 7.62172 17.1196 7.65103L7.07078 13.5994L7.05864 13.6061C6.75152 13.7971 6.65737 14.2009 6.84835 14.5081C6.90462 14.5986 6.98213 14.6739 7.07415 14.7277L17.123 20.6761C17.1665 20.7051 17.2115 20.7319 17.2579 20.7563C17.6459 20.9565 18.1068 20.9565 18.4948 20.7563C18.5411 20.7319 18.5861 20.7051 18.6296 20.6761L28.6785 14.7277C28.8792 14.6107 29.0018 14.3949 28.9995 14.1625Z" fill="#0A2767"></path>
						<path d="M8.24258 10.1913H14.837V16.2361H8.24258V10.1913ZM27.651 4.04663V1.28151C27.6668 0.590168 27.1196 0.0166882 26.4283 0.00012207H9.31559C8.62425 0.0166882 8.07703 0.590168 8.09286 1.28151V4.04663L18.2091 6.7443L27.651 4.04663Z" fill="#0364B8"></path><path d="M8.09308 4.04675H14.8373V10.1165H8.09308V4.04675Z" fill="#0078D4"></path><path d="M21.5818 4.04675H14.8376V10.1165L21.5818 16.1863H27.6516V10.1165L21.5818 4.04675Z" fill="#28A8EA"></path>
						<path d="M14.8376 10.116H21.5818V16.1857H14.8376V10.116Z" fill="#0078D4"></path>
						<path d="M14.8376 16.1858H21.5818V22.2556H14.8376V16.1858Z" fill="#0364B8"></path>
						<path d="M8.24286 16.2358H14.8373V21.731H8.24286V16.2358Z" fill="#14447D"></path>
						<path d="M21.5812 16.1858H27.6509V22.2556H21.5812V16.1858Z" fill="#0078D4"></path>
						<path d="M28.6909 14.6905L28.6781 14.6973L18.6293 20.3489C18.5854 20.3759 18.5409 20.4015 18.4944 20.4244C18.3237 20.5057 18.1384 20.5516 17.9495 20.5593L17.4005 20.2383C17.3541 20.215 17.3091 20.1891 17.2656 20.1607L7.0819 14.3486H7.07718L6.74402 14.1625V25.6033C6.74921 26.3666 7.37203 26.9813 8.13534 26.9764H27.6301C27.6415 26.9764 27.6517 26.971 27.6638 26.971C27.825 26.9607 27.984 26.9276 28.1359 26.8726C28.2015 26.8448 28.2649 26.8118 28.3254 26.7741C28.3706 26.7485 28.4481 26.6925 28.4481 26.6925C28.7936 26.4369 28.9981 26.0331 28.9998 25.6033V14.1625C28.9996 14.3813 28.8816 14.5831 28.6909 14.6905Z" fill="url(#paint0_linear_6481_9712)"></path>
						<path opacity="0.5" d="M28.4605 14.1174V14.8188L17.9531 22.0533L7.0747 14.3534C7.0747 14.3497 7.07168 14.3467 7.06796 14.3467L6.06982 13.7465V13.2406L6.48122 13.2339L7.35121 13.733L7.37144 13.7397L7.44562 13.7869C7.44562 13.7869 17.6698 19.6206 17.6968 19.6341L18.0879 19.8634C18.1217 19.8499 18.1554 19.8364 18.1958 19.8229C18.2161 19.8095 28.3458 14.1106 28.3458 14.1106L28.4605 14.1174Z" fill="#0A2767"></path>
						<path d="M28.6909 14.6905L28.6781 14.698L18.6293 20.3496C18.5854 20.3766 18.5409 20.4022 18.4944 20.4251C18.1041 20.6158 17.6477 20.6158 17.2575 20.4251C17.2113 20.4022 17.1663 20.377 17.1226 20.3496L7.0738 14.698L7.06167 14.6905C6.86766 14.5854 6.74603 14.3832 6.74402 14.1625V25.6033C6.74885 26.3665 7.37144 26.9812 8.13461 26.9764C8.13462 26.9764 8.13464 26.9764 8.13467 26.9764H27.6092C28.3723 26.9813 28.9949 26.3665 28.9998 25.6034C28.9998 25.6034 28.9998 25.6033 28.9998 25.6033V14.1625C28.9996 14.3813 28.8815 14.5831 28.6909 14.6905Z" fill="#1490DF"></path>
						<path opacity="0.1" d="M18.7759 20.2661L18.6255 20.3504C18.5819 20.3782 18.5369 20.4036 18.4906 20.4266C18.3249 20.508 18.1447 20.5556 17.9605 20.5669L21.7838 25.0882L28.4531 26.6953C28.6359 26.5573 28.7812 26.3758 28.876 26.1673L18.7759 20.2661Z" fill="black"></path>
						<path opacity="0.05" d="M19.457 19.8832L18.6255 20.3505C18.5819 20.3783 18.5369 20.4037 18.4906 20.4268C18.3249 20.5081 18.1447 20.5558 17.9605 20.567L19.7518 25.5058L28.4551 26.6934C28.798 26.436 28.9998 26.0323 29 25.6036V25.4559L19.457 19.8832Z" fill="black"></path>
						<path d="M8.15355 26.9764H27.6071C27.9065 26.9779 28.1984 26.8834 28.44 26.7067L17.3998 20.2397C17.3534 20.2164 17.3084 20.1905 17.2649 20.1621L7.08122 14.35H7.0765L6.74402 14.1625V25.5642C6.74326 26.3434 7.37432 26.9757 8.15355 26.9764C8.15353 26.9764 8.15353 26.9764 8.15355 26.9764Z" fill="#28A8EA"></path>
						<path opacity="0.1" d="M16.1859 6.63135V21.0167C16.1847 21.5211 15.878 21.9744 15.4103 22.1632C15.2654 22.2255 15.1094 22.2576 14.9517 22.2576H6.74402V6.06955H8.09286V5.39514H14.9517C15.633 5.39772 16.1844 5.95001 16.1859 6.63135Z" fill="black"></path>
						<path opacity="0.2" d="M15.5115 7.30572V21.691C15.5132 21.854 15.4786 22.0152 15.4103 22.1631C15.223 22.6248 14.7755 22.9277 14.2773 22.9299H6.74402V6.06952H14.2773C14.473 6.06755 14.6658 6.11636 14.837 6.21115C15.2505 6.41943 15.5113 6.8428 15.5115 7.30572Z" fill="black"></path>
						<path opacity="0.2" d="M15.5115 7.30572V20.3422C15.5082 21.0232 14.9583 21.5752 14.2773 21.5811H6.74402V6.06952H14.2773C14.473 6.06755 14.6658 6.11636 14.837 6.21115C15.2505 6.41943 15.5113 6.8428 15.5115 7.30572Z" fill="black"></path><path opacity="0.2" d="M14.837 7.30566V20.3422C14.8363 21.0242 14.2849 21.5777 13.6029 21.5811H6.74402V6.06946H13.6028C14.2848 6.06982 14.8374 6.623 14.837 7.305C14.837 7.30522 14.837 7.30544 14.837 7.30566Z" fill="black"></path>
						<path d="M1.2362 6.06946H13.601C14.2837 6.06946 14.8372 6.62293 14.8372 7.30566V19.6704C14.8372 20.3532 14.2837 20.9066 13.601 20.9066H1.2362C0.553461 20.9066 0 20.3532 0 19.6704V7.30566C0 6.62293 0.553477 6.06946 1.2362 6.06946Z" fill="url(#paint1_linear_6481_9712)"></path>
						<path d="M3.86404 11.2549C4.16872 10.6057 4.66051 10.0625 5.27628 9.69497C5.9582 9.30456 6.73462 9.10993 7.52007 9.1325C8.24805 9.11671 8.96638 9.30125 9.5966 9.66596C10.1892 10.0193 10.6664 10.5371 10.9704 11.1564C11.3015 11.8389 11.4665 12.5899 11.4519 13.3483C11.468 14.1408 11.2982 14.9261 10.9562 15.6413C10.645 16.2828 10.1526 16.819 9.53995 17.1837C8.88543 17.5596 8.14043 17.749 7.38586 17.7313C6.64234 17.7493 5.90817 17.5626 5.26347 17.1918C4.66579 16.838 4.18257 16.3196 3.87147 15.6986C3.53843 15.026 3.37147 14.2834 3.38454 13.5331C3.37067 12.7472 3.53459 11.9685 3.86404 11.2549ZM5.36934 14.917C5.53179 15.3274 5.80727 15.6833 6.1638 15.9434C6.52696 16.1973 6.96181 16.3282 7.40473 16.3171C7.87642 16.3357 8.34136 16.2003 8.72929 15.9313C9.08131 15.672 9.34955 15.3151 9.50082 14.9048C9.66992 14.4467 9.75336 13.9614 9.74698 13.473C9.75221 12.9801 9.67377 12.4898 9.51498 12.0231C9.37474 11.6017 9.11514 11.2301 8.76773 10.9534C8.38953 10.6717 7.92583 10.5288 7.45463 10.5488C7.00212 10.5371 6.55753 10.669 6.18471 10.9258C5.82214 11.187 5.54143 11.5461 5.37541 11.961C5.0071 12.912 5.00519 13.966 5.37001 14.9183L5.36934 14.917Z" fill="white"></path>
						<path d="M21.5812 4.04675H27.6509V10.1165H21.5812V4.04675Z" fill="#50D9FF"></path>
					</g>
					<defs>
						<linearGradient id="paint0_linear_6481_9712" x1="17.8719" y1="14.1625" x2="17.8719" y2="26.9764" gradientUnits="userSpaceOnUse">
							<stop stop-color="#35B8F1"></stop>
							<stop offset="1" stop-color="#28A8EA"></stop>
						</linearGradient>
						<linearGradient id="paint1_linear_6481_9712" x1="2.57752" y1="5.10351" x2="12.2597" y2="21.8726" gradientUnits="userSpaceOnUse">
							<stop stop-color="#1784D9"></stop>
							<stop offset="0.5" stop-color="#107AD5"></stop>
							<stop offset="1" stop-color="#0A63C9"></stop>
						</linearGradient>
						<clipPath id="clip0_6481_9712">
							<rect width="29" height="26.9767" fill="white"></rect>
						</clipPath>
					</defs>
				</svg>
				<span class="email-opener"><?php esc_html_e( 'Open Outlook', 'mailchimp' ); ?></span>
			</a>
		</div>
		<div class="mailchimp-sf-confirm-email-footer">
			<p>
				<?php esc_html_e( 'Didn\'t get an email? Check your spam folder!', 'mailchimp' ); ?>
			</p>
			<p>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=mailchimp_sf_create_account&retry=1' ) ); ?>">
					<?php esc_html_e( 'Re-enter your email and try again', 'mailchimp' ); ?>
				</a>
			</p>
		</div>
	</div>
</div>
