<?php
/*
Plugin Name: Extras Visual Composer by AweThemes
Description: Description
Plugin URI: http://#
Author: Author
Author URI: http://#
Version: 1.0
License: GPL2
Text Domain: Text Domain
Domain Path: Domain Path
*/

define( 'EXTRAS_VC_URL', plugin_dir_url( __FILE__ ) );
define( 'EXTRAS_VC_PATH', plugin_dir_path( __FILE__ ) );

$paths = require EXTRAS_VC_PATH . '/inc/utils.php';


add_action( 'vc_after_init', function() {
	require_once 'inc/class-atshortcode-abstract.php';

	dummy_autoload_shortcodes();
} );

function dummy_autoload_shortcodes() {
	$paths = glob( __DIR__ . '/inc/shortcodes/*.php' );

	foreach ( $paths as $path ) {
		if ( false === strpos( basename( $path ),  'awethemes-' ) ) {
			continue;
		}

		require_once $path;
	}
}

add_action( 'admin_init', function() {

	// vc_add_param('vc_row',array(
	// 		"type" => "colorpicker",
	// 		"class" => "",
	// 		"heading" => __("Color of Controls Icon", "ultimate_vc"),
	// 		"param_name" => "controls_color",
	// 		//"admin_label" => true,
	// 		//"description" => __("Display play / pause controls for the video on bottom right position.", "upb_parallax"),
	// 		// "dependency" => Array("element" => "enable_controls","value" => array("display_control")),
	// 		"group" => 'Extras',
	// 	)
	// );

} );

/**
 * //
 *
 * @access private
 *
 * @param  string            $output    Origin vc_row output template.
 * @param  WPBakeryShortCode $shortcode The shortcode instance class.
 * @param  array             $atts      Default shortcode atts.
 *
 * @return string
 */
function _vc_row_hook( $output, $shortcode, $atts ) {
	if ( 'vc_row' !== $shortcode->getShortcode() ) {
		return $output;
	}

	$content = apply_filters( 'after_open_vc_row', '', $output, $shortcode, $atts );

	return preg_replace( '/(<div[^>]+class="[^"]*vc_row[^>]*>)/', "$1\n{$content}\n", $output );
}
add_filter( 'vc_shortcode_output', '_vc_row_hook', 10, 3 );
