<?php
/*
Plugin Name: Hillter Require Plugin
Plugin URI: https://awethemes.com/
Description: AweThemes Plugin. <a href="http://awethemes.com/docs">Documentation</a>.
Author: awethemes
Author URI: https://awethemes.com
Version: 1.2
*/

defined( 'LANGUAGE' ) || define( 'LANGUAGE', 'hillter' );

class Hillter_Require {

	public function __construct() {
		// Add post type & taxonomy
		add_action( 'init', array( $this, 'register_post_types' ) );
		add_action( 'init', array( $this, 'register_taxonomies' ), 0 );

		$this->includes();
	}


	public function register_post_types() {
		// Event
		$labels = array(
			'name'               => __( 'Events', LANGUAGE ),
			'singular_name'      => __( 'Event', LANGUAGE ),
			'menu_name'          => __( 'Events', LANGUAGE ),
			'name_admin_bar'     => __( 'Event', LANGUAGE ),
			'add_new'            => __( 'Add New', LANGUAGE ),
			'add_new_item'       => __( 'Add New Event', LANGUAGE ),
			'new_item'           => __( 'New Event', LANGUAGE ),
			'edit_item'          => __( 'Edit Event', LANGUAGE ),
			'view_item'          => __( 'View Event', LANGUAGE ),
			'all_items'          => __( 'All Events', LANGUAGE ),
			'search_items'       => __( 'Search Events', LANGUAGE ),
			'parent_item_colon'  => __( 'Parent Events:', LANGUAGE ),
			'not_found'          => __( 'No Events found.', LANGUAGE ),
			'not_found_in_trash' => __( 'No Events found in Trash.', LANGUAGE ),
		);

		$args = array(
			'labels'             => $labels,
			'public'             => true,
			'publicly_queryable' => true,
			'show_ui'            => true,
			'show_in_menu'       => true,
			'query_var'          => true,
			'rewrite'            => array( 'slug' => 'event' ),
			'capability_type'    => 'post',
			'has_archive'        => true,
			'hierarchical'       => false,
			'menu_position'      => 5,
			'menu_icon'          => 'dashicons-calendar',
			'taxonomies'         => array( 'event-category', 'event-tag' ),
			'supports'           => array( 'title', 'editor', 'author', 'thumbnail', 'comments' ),
		);

		register_post_type( 'event', $args );

		// Gallery
		$labels = array(
			'name'               => _x( 'Galleries', '', LANGUAGE ),
			'singular_name'      => _x( 'Gallery', '', LANGUAGE ),
			'menu_name'          => __( 'Gallery', LANGUAGE ),
			'name_admin_bar'     => __( 'Gallery', LANGUAGE ),
			'parent_item_colon'  => __( 'Parent Gallery:', LANGUAGE ),
			'all_items'          => __( 'All Galleries', LANGUAGE ),
			'add_new_item'       => __( 'Add New Gallery', LANGUAGE ),
			'add_new'            => __( 'Add New', LANGUAGE ),
			'new_item'           => __( 'New Gallery', LANGUAGE ),
			'edit_item'          => __( 'Edit Gallery', LANGUAGE ),
			'update_item'        => __( 'Update Gallery', LANGUAGE ),
			'view_item'          => __( 'View Gallery', LANGUAGE ),
			'search_items'       => __( 'Search Gallery', LANGUAGE ),
			'not_found'          => __( 'Not found', LANGUAGE ),
			'not_found_in_trash' => __( 'Not found in Trash', LANGUAGE ),
		);

		$args = array(
			'labels'             => $labels,
			'description'        => __( 'Gallery.', 'your-plugin-textdomain' ),
			'public'             => true,
			'publicly_queryable' => true,
			'show_ui'            => true,
			'show_in_menu'       => true,
			'query_var'          => true,
			'rewrite'            => array( 'slug' => 'gallery' ),
			'capability_type'    => 'post',
			'has_archive'        => true,
			'hierarchical'       => false,
			'menu_position'      => null,
			'supports'           => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments' ),
		);
		register_post_type( 'gallery', $args );
	}


	public function register_taxonomies() {
		$labels = array(
			'name'              => __( 'Event Categories', LANGUAGE ),
			'singular_name'     => __( 'Event Category', LANGUAGE ),
			'search_items'      => __( 'Search Event Categories', LANGUAGE ),
			'all_items'         => __( 'All Event Categories', LANGUAGE ),
			'parent_item'       => __( 'Parent Event Category', LANGUAGE ),
			'parent_item_colon' => __( 'Parent Event Category:', LANGUAGE ),
			'edit_item'         => __( 'Edit Event Category', LANGUAGE ),
			'update_item'       => __( 'Update Event Category', LANGUAGE ),
			'add_new_item'      => __( 'Add New Event Category', LANGUAGE ),
			'new_item_name'     => __( 'New Event Category Name', LANGUAGE ),
			'menu_name'         => __( 'Event Category', LANGUAGE ),
		);

		$args = array(
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'event-category' ),
		);

		register_taxonomy( 'event-category', array( 'event' ), $args );

		// Event Tag
		$labels = array(
			'name'                       => __( 'Event Tags', LANGUAGE ),
			'singular_name'              => __( 'Event Tag', LANGUAGE ),
			'search_items'               => __( 'Search Event Tags', LANGUAGE ),
			'popular_items'              => __( 'Popular Event Tags', LANGUAGE ),
			'all_items'                  => __( 'All Event Tags', LANGUAGE ),
			'edit_item'                  => __( 'Edit Event Tag', LANGUAGE ),
			'update_item'                => __( 'Update Event Tag', LANGUAGE ),
			'add_new_item'               => __( 'Add New Event Tag', LANGUAGE ),
			'new_item_name'              => __( 'New Event Tag Name', LANGUAGE ),
			'separate_items_with_commas' => __( 'Separate Event Tags with commas', LANGUAGE ),
			'add_or_remove_items'        => __( 'Add or remove Event Tags', LANGUAGE ),
			'choose_from_most_used'      => __( 'Choose from the most used Event Tags', LANGUAGE ),
			'not_found'                  => __( 'No Event Tags found.', LANGUAGE ),
			'menu_name'                  => __( 'Event Tags', LANGUAGE ),
		);

		$args = array(
			'hierarchical'          => false,
			'labels'                => $labels,
			'show_ui'               => true,
			'show_admin_column'     => true,
			'query_var'             => true,
			'rewrite'               => array( 'slug' => 'event-tag' ),
		);

		register_taxonomy( 'event-tag', array( 'event' ), $args );

		// Gallery cat
		$labels = array(
			'name'                       => _x( 'Gallery Categories', 'Taxonomy General Name', LANGUAGE ),
			'singular_name'              => _x( 'Categories', 'Taxonomy Singular Name', LANGUAGE ),
			'menu_name'                  => __( 'Categories', LANGUAGE ),
			'all_items'                  => __( 'All Items', LANGUAGE ),
			'parent_item'                => __( 'Parent Item', LANGUAGE ),
			'parent_item_colon'          => __( 'Parent Item:', LANGUAGE ),
			'new_item_name'              => __( 'New Category', LANGUAGE ),
			'add_new_item'               => __( 'Add New Category', LANGUAGE ),
			'edit_item'                  => __( 'Edit Category', LANGUAGE ),
			'update_item'                => __( 'Update Category', LANGUAGE ),
			'view_item'                  => __( 'View Category', LANGUAGE ),
			'separate_items_with_commas' => __( 'Separate items with commas', LANGUAGE ),
			'add_or_remove_items'        => __( 'Add or remove items', LANGUAGE ),
			'choose_from_most_used'      => __( 'Choose from the most used', LANGUAGE ),
			'popular_items'              => __( 'Popular Items', LANGUAGE ),
			'search_items'               => __( 'Search Items', LANGUAGE ),
			'not_found'                  => __( 'Not Found', LANGUAGE ),
		);

		$args = array(
			'labels'            => $labels,
			'hierarchical'      => true,
			'label'             => 'Categories',
			'show_ui'           => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'gallery_cat', 'with_front' => true ),
			'show_admin_column' => true,

		);
		register_taxonomy( 'gallery_cat', array( 'gallery' ), $args );
	}


	public function includes() {
		require_once plugin_dir_path( __FILE__ ) . 'inc/extras-composer/init.php';
	}
}

// Datepicker field
function awe_add_shortcode_date() {
	wpcf7_add_shortcode( array( 'awe_date', 'awe_date*' ), 'awe_add_shortcode_date_handler', true ); // "clock" is the type of the form-tag
}

function awe_add_shortcode_date_handler( $tag ) {
	if ( ! is_array( $tag ) ) {
		return '';
	}

	$type = $tag['type'];
	$name = $tag['name'];
	$options = ( array ) $tag['options'];
	$values = ( array ) $tag['values'];

	if ( empty( $name ) ) {
		return '';
	}

	$validation_error = wpcf7_get_validation_error( $name );

	$atts = $id_att = $size_att = $maxlength_att = '';
	$tabindex_att = $title_att = $date_format = '';
	$placeholder = false;

	$class_att = wpcf7_form_controls_class( $type, 'wpcf7-text' );

	if ( 'email' == $type || 'email*' == $type ) {
		$class_att .= ' wpcf7-validates-as-email';
	}

	if ( 'digit' == $type || 'digit*' == $type ) {
		$class_att .= ' wpcf7-validates-as-digit';
	}

	if ( $validation_error ) {
		$class_att .= ' wpcf7-not-valid';
	}

	foreach ( $options as $option ) {
		if ( preg_match( '%^id:([-0-9a-zA-Z_]+)$%', $option, $matches ) ) {
			$id_att = $matches[1];
		} elseif ( preg_match( '%^class:([-0-9a-zA-Z_]+)$%', $option, $matches ) ) {
			$class_att .= ' ' . $matches[1];
		} elseif ( preg_match( '%^([0-9]*)[/x]([0-9]*)$%', $option, $matches ) ) {
			$size_att = ( int ) $matches[1];
			$maxlength_att = ( int ) $matches[2];
		} elseif ( preg_match( '%^tabindex:(\d+)$%', $option, $matches ) ) {
			$tabindex_att = ( int ) $matches[1];
		} elseif ( strpos( $option, 'date-format:' ) !== false ) {
			$date_format = explode( 'date-format:', $option );
			$date_format = $date_format[1];
		} elseif ( strpos( $option, 'placeholder' ) !== false ) {
			$placeholder = true;
		}
	}

	$value = ( string ) reset( $values );

	if ( wpcf7_script_is() && preg_grep( '%^watermark$%', $options ) ) {
		$class_att .= ' wpcf7-use-title-as-watermark';
		$title_att .= sprintf( ' %s', $value );
		$value = '';
	} elseif ( empty( $value ) && is_user_logged_in() ) {
		$user = wp_get_current_user();

		$user_options = array(
			'default:user_login' => 'user_login',
			'default:user_email' => 'user_email',
			'default:user_url' => 'user_url',
			'default:user_first_name' => 'first_name',
			'default:user_last_name' => 'last_name',
			'default:user_nickname' => 'nickname',
			'default:user_display_name' => 'display_name',
		);

		foreach ( $user_options as $option => $prop ) {
			if ( preg_grep( '%^' . $option . '$%', $options ) ) {
				$value = $user->{$prop};
				break;
			}
		}
	}

	if ( wpcf7_is_posted() && isset( $_POST[ $name ] ) ) {
		$value = stripslashes_deep( $_POST[ $name ] );
	}

	if ( $id_att ) {
		$atts .= ' id="' . trim( $id_att ) . '"';
	}

	if ( $class_att ) {
		$atts .= ' class="' . trim( $class_att ) . '"';
	}

	if ( $size_att ) {
		$atts .= ' size="' . $size_att . '"';
	}
	// else
	//     $atts .= ' size="40"'; // default size

	if ( $maxlength_att ) {
		$atts .= ' maxlength="' . $maxlength_att . '"';
	}

	if ( '' !== $tabindex_att ) {
		$atts .= sprintf( ' tabindex="%d"', $tabindex_att );
	}

	if ( $title_att ) {
		$atts .= sprintf( ' title="%s"', trim( esc_attr( $title_att ) ) );
	}

	if ( ! $placeholder ) {
		$html = '<input type="text" data-format="' . esc_attr( $date_format ) . '" name="' . $name . '" value="' . esc_attr( $value ) . '"' . $atts . ' />';
	} else {
		$html = '<input type="text" data-format="' . esc_attr( $date_format ) . '" name="' . $name . '" placeholder="' . esc_attr( $value ) . '"' . $atts . ' />';
	}

	$html = '<span class="wpcf7-form-control-wrap awe-form-control-datepicker ' . $name . '">' . $html . $validation_error . '</span>';

	return $html;

}


// validate
function awe_date_validation_filter( $result, $tag ) {
	$tag = new WPCF7_Shortcode( $tag );
	$name = $tag->name;

	$value = isset( $_POST[ $name ] ) ? trim( strtr( (string) $_POST[ $name ], "\n", ' ' ) ) : '';

	// required field
	if ( $tag->is_required() && '' == $value ) {
		$result->invalidate( $tag, wpcf7_get_message( 'invalid_required' ) );
	}

	return $result;
}


// load generator
function awe_generator_date() {
	wpcf7_add_tag_generator( 'awe-date', __( 'AWE Date', 'awelang' ), 'wpcf7-tg-pane-awe-date', 'awe_generator_date_callback' );
}

function awe_generator_date_callback() {
	?>

		<div id="wpcf7-tg-pane-awe-date">
			<form action="">
				<div class="control-box">
					<fieldset>
						<legend><?php esc_html_e( 'Generate a form-tag for a date input field.', 'awelang' ); ?></legend>
						<table class="form-table">
							<tbody>
								<tr>
									<th scope="row">
										<?php echo esc_html_x( 'Field type', 'contact form 7', 'awelang' ); ?>
									</th>
									<td>
										<fieldset>
											<legend class="screen-reader-text"><?php echo esc_html_x( 'Field type', 'contact form 7', 'awelang' ); ?></legend>
											<label><input type="checkbox" name="required"> <?php echo esc_html_x( 'Required field', 'contact form 7', 'awelang' ); ?></label>
										</fieldset>
									</td>
								</tr>

								<tr>
									<th scope="row"><label for="tag-generator-panel-awe-date-name"><?php echo esc_html_x( 'Name', 'contact form 7', 'awelang' ); ?></label></th>
									<td><input type="text" name="name" class="tg-name oneline" id="tag-generator-panel-awe-date-name"></td>
								</tr>

								<tr>
									<th scope="row"><label for="tag-generator-panel-text-values"><?php esc_html_e( 'Default value', 'awelang' ); ?></label></th>
									<td><input type="text" name="values" class="oneline" id="tag-generator-panel-text-values"><br>
										<label><input type="checkbox" name="placeholder" class="option"> <?php esc_html_e( 'Use this text as the placeholder of the field', 'awelang' ); ?></label>
									</td>
								</tr>

								<tr>
									<th scope="row"><label for="tag-generator-panel-awe-date-date-format"><?php echo esc_attr_x( 'Date format', 'contact form 7', 'awelang' ); ?></label></th>
									<td>
										<!-- <input type="text" name="date-format" class="oneline option" id="tag-generator-panel-awe-date-date-format"> -->
										<fieldset>
											<legend class="screen-reader-text"><?php echo esc_attr_x( 'Date format', 'contact form 7', 'awelang' ); ?></legend>
											<select id="tag-generator-panel-awe-date-date-format" class="oneline option">
												<option value="mm/dd/yy" selected="selected">mm/dd/yyyy</option>
												<option value="dd/mm/yy">dd/mm/yyyy</option>
												<option value="yy/mm/dd">yyyy/mm/dd</option>
												<option value="yy/dd/mm">yyyy/dd/mm</option>
											</select>
											<input type="hidden" name="date-format" class="oneline option">
										</fieldset>
									</td>
								</tr>

								<tr>
									<th scope="row"><label for="tag-generator-panel-awe-date-id"><?php echo esc_attr_x( 'Id attribute', 'contact form 7', 'awelang' ); ?></label></th>
									<td><input type="text" name="id" class="idvalue oneline option" id="tag-generator-panel-awe-date-id"></td>
								</tr>

								<tr>
									<th scope="row"><label for="tag-generator-panel-awe-date-class"><?php echo esc_attr_x( 'Class attribute', 'contact form 7', 'awelang' ); ?></label></th>
									<td><input type="text" name="class" class="classvalue oneline option" id="tag-generator-panel-awe-date-class"></td>
								</tr>
							</tbody>
						</table>
					</fieldset>
				</div>

				<div class="insert-box">
					<input type="text" name="awe_date" class="tag code" readonly="readonly" onfocus="this.select()">

					<div class="submitbox">
						<input type="button" class="button button-primary insert-tag" value="<?php echo esc_attr_x( 'Insert Tag', 'contact form 7', 'awelang' ); ?>">
					</div>

					<br class="clear">

					<p class="description mail-tag"><label for="tag-generator-panel-date-mailtag">To use the value input through this field in a mail field, you need to insert the corresponding mail-tag (<strong><span class="mail-tag">[date-898]</span></strong>) into the field on the Mail tab.<input type="text" class="mail-tag code hidden" readonly="readonly" id="tag-generator-panel-date-mailtag"></label></p>
				</div>
			</form>
		</div>

		<script type="text/javascript">
			(function($){
				"use strict";

				$(document).ready(function() {

					$('#tag-generator-panel-awe-date-date-format').on('change', function() {
						$(this).next().val($(this).val());
						$(this).next().trigger('change');
					});
				});

			})(jQuery);
		</script>


	<?php
}


// load script
function awe_cf7_load_script() {
	wp_enqueue_script( 'jquery-ui-datepicker' );
	wp_enqueue_script( 'awe-js-contact-form', get_template_directory_uri() . '/assets/js/contact-form.js', array( 'jquery-ui-datepicker' ), false, true );
}


// Add error message
// add_filter( 'wpcf7_messages', 'awe_cf7_messages' );
function awe_cf7_messages( $message ) {
	var_dump( $message );
}


function awe_hillter_require_init() {
	if ( has_action( 'wpcf7_init' ) ) {
		add_action( 'wp_enqueue_scripts', 'awe_cf7_load_script' );

		// Add generator for awe date field
		add_action( 'load-contact_page_wpcf7-new', 'awe_generator_date' );
		add_action( 'load-toplevel_page_wpcf7', 'awe_generator_date' );

		// Validate
		add_filter( 'wpcf7_validate_awe_date', 'awe_date_validation_filter', 10, 2 );
		add_filter( 'wpcf7_validate_awe_date*', 'awe_date_validation_filter', 10, 2 );

		// Add shortcode
		add_action( 'wpcf7_init', 'awe_add_shortcode_date' );
	}

	new Hillter_Require();
}
add_action( 'plugins_loaded', 'awe_hillter_require_init' );
