<?php

return [ // @codingStandardsIgnoreStart
	'required'       => esc_html__( 'is required', 'wplibs-form' ),
	'equals'         => esc_html__( "must be the same as '%s'", 'wplibs-form' ),
	'different'      => esc_html__( "must be different than '%s'", 'wplibs-form' ),
	'accepted'       => esc_html__( 'must be accepted', 'wplibs-form' ),
	'numeric'        => esc_html__( 'must be numeric', 'wplibs-form' ),
	'integer'        => esc_html__( 'must be an integer', 'wplibs-form' ),
	'length'         => esc_html__( 'must be %d characters long', 'wplibs-form' ),
	'min'            => esc_html__( 'must be at least %s', 'wplibs-form' ),
	'max'            => esc_html__( 'must be no more than %s', 'wplibs-form' ),
	'in'             => esc_html__( 'contains invalid value', 'wplibs-form' ),
	'notIn'          => esc_html__( 'contains invalid value', 'wplibs-form' ),
	'ip'             => esc_html__( 'is not a valid IP address', 'wplibs-form' ),
	'ipv4'           => esc_html__( 'is not a valid IPv4 address', 'wplibs-form' ),
	'ipv6'           => esc_html__( 'is not a valid IPv6 address', 'wplibs-form' ),
	'email'          => esc_html__( 'is not a valid email address', 'wplibs-form' ),
	'url'            => esc_html__( 'is not a valid URL', 'wplibs-form' ),
	'urlActive'      => esc_html__( 'must be an active domain', 'wplibs-form' ),
	'alpha'          => esc_html__( 'must contain only letters a-z', 'wplibs-form' ),
	'alphaNum'       => esc_html__( 'must contain only letters a-z and/or numbers 0-9', 'wplibs-form' ),
	'slug'           => esc_html__( 'must contain only letters a-z, numbers 0-9, dashes and underscores', 'wplibs-form' ),
	'regex'          => esc_html__( 'contains invalid characters', 'wplibs-form' ),
	'date'           => esc_html__( 'is not a valid date', 'wplibs-form' ),
	'dateFormat'     => esc_html__( "must be date with format '%s'", 'wplibs-form' ),
	'dateBefore'     => esc_html__( "must be date before '%s'", 'wplibs-form' ),
	'dateAfter'      => esc_html__( "must be date after '%s'", 'wplibs-form' ),
	'contains'       => esc_html__( 'must contain %s', 'wplibs-form' ),
	'boolean'        => esc_html__( 'must be a boolean', 'wplibs-form' ),
	'lengthBetween'  => esc_html__( 'must be between %d and %d characters', 'wplibs-form' ),
	'creditCard'     => esc_html__( 'must be a valid credit card number', 'wplibs-form' ),
	'lengthMin'      => esc_html__( 'must be at least %d characters long', 'wplibs-form' ),
	'lengthMax'      => esc_html__( 'must not exceed %d characters', 'wplibs-form' ),
	'instanceOf'     => esc_html__( "must be an instance of '%s'", 'wplibs-form' ),
	'containsUnique' => esc_html__( 'must contain unique elements only', 'wplibs-form' ),
	'subset'         => esc_html__( 'contains an item that is not in the list', 'wplibs-form' ),
]; // @codingStandardsIgnoreEnd
