<?php

if ( ! function_exists( 'array_except' ) ) {
	/**
	 * Get all of the given array except for a specified array of items.
	 *
	 * @param  array        $array
	 * @param  array|string $keys
	 * @return array
	 */
	function array_except( $array, $keys ) {
		return array_diff_key( $array, array_flip( (array) $keys ) );
	}
}

if ( ! function_exists( 'array_only' ) ) {
	/**
	 * Get a subset of the items from the given array.
	 *
	 * @param  array        $array
	 * @param  array|string $keys
	 * @return array
	 */
	function array_only( $array, $keys ) {
		return array_intersect_key( $array, array_flip( (array) $keys ) );
	}
}

class Extras_Composer_Utils {

	/**
	 * Get public post type for dropdown (select).
	 */
	public static function get_dropdown_post_types( $args = array(), $flip = true ) {
		$excluded_post_types = apply_filters( 'vc_extras_excluded_post_types', array(
			'attachment',
			'megamenu',
		) );

		$args = wp_parse_args( $args, array( 'public' => true ) );

		$post_types = array_except( get_post_types( $args ), $excluded_post_types );
		$post_types = array_map( function ( $value ) {
			return ucfirst( str_replace( array( '-', '_' ), ' ', $value ) );
		}, $post_types );

		return $flip ? array_flip( $post_types ) : $post_types;
	}
}
