<?php
/**
 * Awethemes Shortcode Abstract.
 *
 * @package Awethemes
 */

/**
 * ATShortCode_Abstract class.
 */
class Extras_WPBakeryShortCode extends WPBakeryShortCode {
	/**
	 * //
	 *
	 * @param array $settings //.
	 */
	public function __construct( $settings ) {
		parent::__construct( $settings );

		$this->registerScripts();

		// Set default html template to render.
		$this->html_template = plugin_dir_path( __FILE__ ) . 'templates/' . $this->shortcode . '.php';
	}

	/**
	 * Register JS and CSS for render page.
	 */
	public function registerScripts() {}

	/**
	 * Enqueue JS and CSS for render page.
	 */
	public function enqueueScripts( $atts ) {}

	/**
	 * //
	 *
	 * @param $atts
	 * @param null $content
	 *
	 * @return mixed|void
	 */
	protected function loadTemplate( $atts, $content = null ) {
		$this->enqueueScripts( $atts );

		return parent::loadTemplate( $atts, $content );
	}

	/**
	 * Find html template for shortcode output.
	 */
	protected function findShortcodeTemplate() {
		$parent_template = parent::findShortcodeTemplate();

		if ( ! $parent_template && is_file( $this->html_template ) ) {
			return $this->setTemplate( $this->html_template );
		}

		return $parent_template;
	}

	/**
	 * Decode HTML for textarea_raw_html param.
	 *
	 * @param  string $string Raw HTML.
	 * @return string
	 */
	public function decode_textarea_raw( $string ) {
		if ( ! $string ) {
			return '';
		}

		return rawurldecode( base64_decode( strip_tags( $string ) ) );
	}

	/**
	 * Build an HTML attribute string from an array.
	 *
	 * @param array $attributes
	 *
	 * @return string
	 */
	public function build_attributes( $attributes ) {
		$html = array();

		foreach ( (array) $attributes as $key => $value ) {
			if ( is_numeric( $key ) ) {
				$key = $value;
			}

			if ( ! is_null( $value ) ) {
				$html[] = $key . '="' . esc_attr( $value ) . '"';
			}
		}

		return count( $html ) > 0 ? ' ' . implode( ' ', $html ) : '';
	}

	/**
	 * Build link attr.
	 *
	 * @param  array $attr Link after parser via vc_build_link().
	 */
	protected function build_link_atts( $attr ) {
		if ( ! empty( $attr['url'] ) ) {
			$attr['href'] = esc_url( $attr['url'] );
			unset( $attr['url'] );
		}

		return $this->build_attributes( $attr );
	}
}
